<?php
	$default = ['show_table' => 1, 'show_waiter' => 1, 'table_label' => 'Table', 'waiter_label' => 'Waiter'];

	if(!empty($module_info['Restaurant'])){
		$default['show_table'] = isset($module_info['Restaurant']['show_table']) ? $module_info['Restaurant']['show_table'] : 0;

		$default['show_waiter'] = isset($module_info['Restaurant']['show_waiter']) ? $module_info['Restaurant']['show_waiter'] : 0;

		$default['table_label'] = isset($module_info['Restaurant']['table_label']) ? $module_info['Restaurant']['table_label'] : $default['table_label'];
		
		$default['waiter_label'] = isset($module_info['Restaurant']['waiter_label']) ? $module_info['Restaurant']['waiter_label'] : $default['waiter_label'];
	}
?>

<div class="box box-solid">
    <div class="box-body">
    	<div class="box-header">
            <h3 class="box-title"><?php echo app('translator')->getFromJson('restaurant::lang.restaurant'); ?></h3>
        </div>
		<div class="row">
			<div class="col-sm-3">
				<div class="form-group">
					<div class="checkbox">
						<label>
							<?php echo Form::checkbox('module_info[Restaurant][show_table]', 1, $default['show_table'], ['class' => 'input-icheck']);; ?> <?php echo app('translator')->getFromJson('restaurant::lang.show_table'); ?>
						</label>
					</div>
				</div>
			</div>

			<div class="col-sm-3">
				<div class="form-group">
					<div class="checkbox">
						<label>
							<?php echo Form::checkbox('module_info[Restaurant][show_waiter]', 1, $default['show_waiter'], ['class' => 'input-icheck']);; ?> <?php echo app('translator')->getFromJson('restaurant::lang.show_waiter'); ?>
						</label>
					</div>
				</div>
			</div>

			<div class="col-sm-3">
				<div class="form-group">
					<?php echo Form::label('table_label', __('restaurant::lang.table_label') . ':' ); ?>

					<?php echo Form::text('module_info[Restaurant][table_label]', $default['table_label'], ['class' => 'form-control', 'placeholder' => __('restaurant::lang.table_label') ]);; ?>

				</div>
			</div>

			<div class="col-sm-3">
				<div class="form-group">
					<?php echo Form::label('waiter_label', __('restaurant::lang.waiter_label') . ':' ); ?>

					<?php echo Form::text('module_info[Restaurant][waiter_label]', $default['waiter_label'], ['class' => 'form-control', 'placeholder' => __('restaurant::lang.waiter_label') ]);; ?>

				</div>
			</div>

		</div>
	</div>
</div>