<?php $__env->startSection('title', __('superadmin::lang.superadmin') . ' | ' . __('superadmin::lang.subscription')); ?>

<?php $__env->startSection('content'); ?>

<!-- Main content -->
<section class="content">

	<!-- Page level currency setting -->
	<input type="hidden" id="p_code" value="<?php echo e($system_currency->code); ?>">
	<input type="hidden" id="p_symbol" value="<?php echo e($system_currency->symbol); ?>">
	<input type="hidden" id="p_thousand" value="<?php echo e($system_currency->thousand_separator); ?>">
	<input type="hidden" id="p_decimal" value="<?php echo e($system_currency->decimal_separator); ?>">
	
	<div class="box">
        <div class="box-header">
            <h3 class="box-title"><?php echo app('translator')->getFromJson('superadmin::lang.active_subscription'); ?></h3>
        </div>

        <div class="box-body">
        	<?php if(!empty($active)): ?>
        		<div class="col-md-4">
	        		<div class="box box-success">
						<div class="box-header with-border text-center">
							<h2 class="box-title">
								<?php echo e($active->package_details['name']); ?>

							</h2>

							<div class="box-tools pull-right">
								<span class="badge bg-green">
									<?php echo app('translator')->getFromJson('superadmin::lang.running'); ?>
								</span>
              				</div>

						</div>
						<div class="box-body text-center">
							<?php echo app('translator')->getFromJson('superadmin::lang.start_date'); ?> : <?php echo e($active->start_date->toDateString()); ?> <br/>
							<?php echo app('translator')->getFromJson('superadmin::lang.end_date'); ?> : <?php echo e($active->end_date->toDateString()); ?> <br/>

							<?php echo app('translator')->getFromJson('superadmin::lang.remaining', ['days' => \Carbon::today()->diffInDays($active->end_date)]); ?>

						</div>
					</div>
				</div>
        	<?php else: ?>
        		<h3 class="text-danger"><?php echo app('translator')->getFromJson('superadmin::lang.no_active_subscription'); ?></h3>
        	<?php endif; ?>

        	<?php if(!empty($nexts)): ?>
        		<div class="clearfix"></div>
        		<?php $__currentLoopData = $nexts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $next): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        			<div class="col-md-4">
		        		<div class="box box-success">
							<div class="box-header with-border text-center">
								<h2 class="box-title">
									<?php echo e($next->package_details['name']); ?>

								</h2>
							</div>
							<div class="box-body text-center">
								<?php echo app('translator')->getFromJson('superadmin::lang.start_date'); ?> : <?php echo e($next->start_date->toDateString()); ?> <br/>
								<?php echo app('translator')->getFromJson('superadmin::lang.end_date'); ?> : <?php echo e($next->end_date->toDateString()); ?>

							</div>
						</div>
					</div>
        		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        	<?php endif; ?>
        </div>
    </div>

    <div class="box">
        <div class="box-header">
            <h3 class="box-title"><?php echo app('translator')->getFromJson('superadmin::lang.packages'); ?></h3>
        </div>

        <div class="box-body">
        	<?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-4">
                	
					<div class="box box-success">
						<div class="box-header with-border text-center">
							<h2 class="box-title"><?php echo e($package->name); ?></h2>
						</div>
						<!-- /.box-header -->
						<div class="box-body text-center">
							<ul>
								<li>
									<?php if($package->location_count == 0): ?>
										<?php echo app('translator')->getFromJson('superadmin::lang.unlimited'); ?>
									<?php else: ?>
										<?php echo e($package->location_count); ?>

									<?php endif; ?>

									<?php echo app('translator')->getFromJson('business.business_locations'); ?>
								</li>

								<li>
									<?php if($package->user_count == 0): ?>
										<?php echo app('translator')->getFromJson('superadmin::lang.unlimited'); ?>
									<?php else: ?>
										<?php echo e($package->user_count); ?>

									<?php endif; ?>

									<?php echo app('translator')->getFromJson('superadmin::lang.users'); ?>
								</li>

								<li>
									<?php if($package->product_count == 0): ?>
										<?php echo app('translator')->getFromJson('superadmin::lang.unlimited'); ?>
									<?php else: ?>
										<?php echo e($package->product_count); ?>

									<?php endif; ?>

									<?php echo app('translator')->getFromJson('superadmin::lang.products'); ?>
								</li>

								<li>
									<?php if($package->invoice_count == 0): ?>
										<?php echo app('translator')->getFromJson('superadmin::lang.unlimited'); ?>
									<?php else: ?>
										<?php echo e($package->invoice_count); ?>

									<?php endif; ?>

									<?php echo app('translator')->getFromJson('superadmin::lang.invoices'); ?>
								</li>

								<?php if($package->trial_days != 0): ?>
									<li>
										<?php echo e($package->trial_days); ?> <?php echo app('translator')->getFromJson('superadmin::lang.trial_days'); ?>
									</li>
								<?php endif; ?>
							</ul>
							<h3 class="text-center">
								<span class="display_currency" data-currency_symbol="true"><?php echo e($package->price); ?></span>

								<small>
									/ <?php echo e($package->interval_count); ?> <?php echo e(ucfirst($package->interval)); ?>

								</small>
							</h3>
							
						</div>
						<!-- /.box-body -->

						<div class="box-footer text-center">
							<a href="<?php echo e(action('\Modules\Superadmin\Http\Controllers\SubscriptionController@pay', [$package->id])); ?>" 
								class="btn btn-block btn-success">
                				<i class="fa fa-check"></i> <?php echo app('translator')->getFromJson('superadmin::lang.pay_and_subscribe'); ?>
                			</a>

                			<?php echo e($package->description); ?>

						</div>
					</div>
					<!-- /.box -->
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
    </div>

</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>