<div class="modal-dialog modal-xl no-print" role="document">
  <div class="modal-content">
    <div class="modal-header">
    <button type="button" class="close no-print" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
    <h4 class="modal-title" id="modalTitle"> <?php echo app('translator')->getFromJson('lang_v1.sell_return'); ?> (<b><?php echo app('translator')->getFromJson('purchase.ref_no'); ?>:</b> <?php echo e($purchase->invoice_no); ?>)
    </h4>
</div>
<div class="modal-body">
  <div class="row">
    <div class="col-xs-12">
        <p class="pull-right"><b><?php echo app('translator')->getFromJson('messages.date'); ?>:</b> <?php echo e(\Carbon::createFromTimestamp(strtotime($purchase->transaction_date))->format(session('business.date_format'))); ?></p>
    </div>
  </div>
  <div class="row invoice-info">
    <div class="col-sm-4 invoice-col word-wrap">
      <?php echo app('translator')->getFromJson('purchase.supplier'); ?>:
      <address>
        <strong><?php echo e($purchase->contact->supplier_business_name); ?></strong>
        <?php echo e($purchase->contact->name); ?>

        <?php if(!empty($purchase->contact->landmark)): ?>
          <br><?php echo e($purchase->contact->landmark); ?>

        <?php endif; ?>
        <?php if(!empty($purchase->contact->city) || !empty($purchase->contact->state) || !empty($purchase->contact->country)): ?>
          <br><?php echo e(implode(',', array_filter([$purchase->contact->city, $purchase->contact->state, $purchase->contact->country]))); ?>

        <?php endif; ?>
        <?php if(!empty($purchase->contact->tax_number)): ?>
          <br><?php echo app('translator')->getFromJson('contact.tax_no'); ?>: <?php echo e($purchase->contact->tax_number); ?>

        <?php endif; ?>
        <?php if(!empty($purchase->contact->mobile)): ?>
          <br><?php echo app('translator')->getFromJson('contact.mobile'); ?>: <?php echo e($purchase->contact->mobile); ?>

        <?php endif; ?>
        <?php if(!empty($purchase->contact->email)): ?>
          <br>Email: <?php echo e($purchase->contact->email); ?>

        <?php endif; ?>
      </address>
    </div>

    <div class="col-md-4 invoice-col word-wrap">
      <?php echo app('translator')->getFromJson('business.business'); ?>:
      <address>
        <strong><?php echo e($purchase->business->name); ?></strong>
        <br/><?php echo e($purchase->location->name); ?>

        <?php if(!empty($purchase->location->landmark)): ?>
          <br><?php echo e($purchase->location->landmark); ?>

        <?php endif; ?>
        <?php if(!empty($purchase->location->city) || !empty($purchase->location->state) || !empty($purchase->location->country)): ?>
          <br><?php echo e(implode(',', array_filter([$purchase->location->city, $purchase->location->state, $purchase->location->country]))); ?>

        <?php endif; ?>
        
        <?php if(!empty($purchase->business->tax_number_1)): ?>
          <br><?php echo e($purchase->business->tax_label_1); ?>: <?php echo e($purchase->business->tax_number_1); ?>

        <?php endif; ?>

        <?php if(!empty($purchase->business->tax_number_2)): ?>
          <br><?php echo e($purchase->business->tax_label_2); ?>: <?php echo e($purchase->business->tax_number_2); ?>

        <?php endif; ?>

        <?php if(!empty($purchase->location->mobile)): ?>
          <br><?php echo app('translator')->getFromJson('contact.mobile'); ?>: <?php echo e($purchase->location->mobile); ?>

        <?php endif; ?>
        <?php if(!empty($purchase->location->email)): ?>
          <br><?php echo app('translator')->getFromJson('business.email'); ?>: <?php echo e($purchase->location->email); ?>

        <?php endif; ?>
      </address>
    </div>

  <div class="col-sm-4 invoice-col">
    <b><?php echo app('translator')->getFromJson('purchase.ref_no'); ?>:</b> #<?php echo e($purchase->invoice_no); ?><br/>
    <b><?php echo app('translator')->getFromJson('messages.date'); ?>:</b> <?php echo e(\Carbon::createFromTimestamp(strtotime($purchase->transaction_date))->format(session('business.date_format'))); ?><br/>
  </div>
</div>

<?php
  $hide_tax = '';
  if( session()->get('business.enable_inline_tax') == 0){
    $hide_tax = 'hide';
  }
?>

  <br>
  <div class="row">
    <div class="col-xs-12">
      <div class="table-responsive">
        <table class="table bg-gray">
          <tr class="bg-green">
            <th>#</th>
            <th class="text-center"><?php echo app('translator')->getFromJson('sale.product'); ?></th>
            <th class="text-center"><?php echo app('translator')->getFromJson('sale.qty'); ?></th>
            <th class="text-center"><?php echo app('translator')->getFromJson('sale.unit_price'); ?></th>
            <th class="text-center <?php echo e($hide_tax); ?>"><?php echo app('translator')->getFromJson('sale.tax'); ?></th>
            <th class="text-center <?php echo e($hide_tax); ?>"><?php echo app('translator')->getFromJson('sale.price_inc_tax'); ?></th>
            <th class="text-center"><?php echo app('translator')->getFromJson('sale.subtotal'); ?></th>
          </tr>

          <?php 
            $total_before_tax = 0.00;
          ?>

          <?php $__currentLoopData = $purchase->purchase_lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase_line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($loop->iteration); ?></td>
              <td>
                <?php echo e($purchase_line->product->name); ?>

                 <?php if( $purchase_line->product->type == 'variable'): ?>
                  - <?php echo e($purchase_line->variations->product_variation->name); ?>

                  - <?php echo e($purchase_line->variations->name); ?>

                 <?php endif; ?>
              </td>
              <td><?php echo e($purchase_line->quantity); ?></td>

              <td>
                <span class="display_currency" data-currency_symbol="true"><?php echo e($purchase_line->purchase_price); ?></span>
              </td>
              
              <td><span class="display_currency" data-currency_symbol="true"><?php echo e($purchase_line->item_tax); ?> </span> <br/><small><?php if($purchase_line->tax_id): ?> ( <?php echo e($taxes[$purchase_line->tax_id]); ?> ) </small><?php endif; ?></td>
              
              <td><span class="display_currency" data-currency_symbol="true"><?php echo e($purchase_line->purchase_price_inc_tax); ?></span></td>

              
              <td><span class="display_currency" data-currency_symbol="true"><?php echo e($purchase_line->purchase_price_inc_tax * $purchase_line->quantity); ?></span></td>
            </tr>
            <?php 
              $total_before_tax += ($purchase_line->quantity * $purchase_line->purchase_price);
            ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </table>
      </div>
    </div>
  </div>

  <br>
  <div class="row">
    <div class="col-xs-6 col-md-offset-6">
      <div class="table-responsive">
        <table class="table">
          <!-- <tr class="hide">
            <th><?php echo app('translator')->getFromJson('purchase.total_before_tax'); ?>: </th>
            <td></td>
            <td><span class="display_currency pull-right"><?php echo e($total_before_tax); ?></span></td>
          </tr> -->
          <tr>
            <th><?php echo app('translator')->getFromJson('purchase.net_total_amount'); ?>: </th>
            <td></td>
            <td><span class="display_currency pull-right"><?php echo e($total_before_tax); ?></span></td>
          </tr>
          <tr>
            <th><?php echo app('translator')->getFromJson('purchase.discount'); ?>:</th>
            <td>
              <b>(-)</b>
              <?php if($purchase->discount_type == 'percentage'): ?>
                (<?php echo e($purchase->discount_amount); ?> %)
              <?php endif; ?>
            </td>
            <td>
              <span class="display_currency pull-right">
                <?php if($purchase->discount_type == 'percentage'): ?>
                  <?php echo e($purchase->discount_amount * $total_before_tax / 100); ?>

                <?php else: ?>
                  <?php echo e($purchase->discount_amount); ?>

                <?php endif; ?>                  
              </span>
            </td>
          </tr>
          <tr>
            <th><?php echo app('translator')->getFromJson('lang_v1.total_credit_amt'); ?>:</th>
            <td></td>
            <td><span class="display_currency pull-right" data-currency_symbol="true" ><?php echo e($purchase->final_total); ?></span></td>
          </tr>
        </table>
      </div>
    </div>
  </div>

  <div class="row">
    <div class="col-sm-6 col-md-offset-6">
      <strong><?php echo app('translator')->getFromJson('purchase.additional_notes'); ?>:</strong><br>
      <p class="well well-sm no-shadow bg-gray">
        <?php if($purchase->additional_notes): ?>
          <?php echo e($purchase->additional_notes); ?>

        <?php else: ?>
          --
        <?php endif; ?>
      </p>
    </div>
  </div>

  
  <div class="row print_section">
    <div class="col-xs-12">
      <img class="center-block" src="data:image/png;base64,<?php echo e(DNS1D::getBarcodePNG($purchase->ref_no, 'C128', 2,30,array(39, 48, 54), true)); ?>">
    </div>
  </div>
</div>
<div class="modal-footer">
    <a href="#" class="print-invoice btn btn-primary" data-href="<?php echo e(action('SellReturnController@printInvoice', [$purchase->id])); ?>"><i class="fa fa-print" aria-hidden="true"></i> <?php echo app('translator')->getFromJson("messages.print"); ?></a>
      <button type="button" class="btn btn-default no-print" data-dismiss="modal"><?php echo app('translator')->getFromJson( 'messages.close' ); ?></button>
    </div>
  </div>
</div>

<script type="text/javascript">
  $(document).ready(function(){
    var element = $('div.modal-xl');
    __currency_convert_recursively(element);
  });
</script>