<?php
  $id = 'modifier_' . time();
?>

<div class="modal fade" id="<?php echo e($id); ?>" tabindex="-1" role="dialog">
<div class="modal-dialog" role="document">
  <div class="modal-content">

    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <h4 class="modal-title"><?php echo app('translator')->getFromJson( 'restaurant::lang.products_for_modifier' ); ?>: <span class="text-success"></span>
      </h4>
    </div>

    <div class="modal-body">
      <?php if(!empty($product_ms)): ?>
        <div class="panel-group" id="accordion<?php echo e($id); ?>" role="tablist" aria-multiselectable="true">

      <?php $__currentLoopData = $product_ms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
          $collapse_id = 'collapse'. $k . $id;
        ?>

        <div class="panel panel-default">
          <div class="panel-heading" role="tab" id="headingOne">
            <h4 class="panel-title">
              <a role="button" data-toggle="collapse" data-parent="#accordion<?php echo e($id); ?>" 
                href="#<?php echo e($collapse_id); ?>" 
                aria-expanded="true" aria-controls="collapseOne">
                <?php echo e($row->modifier_sets->name); ?>

              </a>
            </h4>
          </div>

          <input type="hidden" class="index" value="<?php echo e($index+1); ?>">

          <div id="<?php echo e($collapse_id); ?>" class="panel-collapse collapse <?php if($k==0): ?> in <?php endif; ?>" role="tabpanel" aria-labelledby="headingOne">
            <div class="panel-body">
              <div class="btn-group" data-toggle="buttons">
                <?php $__currentLoopData = $row->modifier_sets->modifiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modifier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <label class="btn btn-primary">
                    <input type="checkbox" autocomplete="off" 
                      value="<?php echo e($modifier->id); ?>"> 
                      <?php echo e($modifier->name); ?>

                  </label>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            </div>
          </div>
        </div>
          
        
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
      <?php endif; ?>
    </div>

    <div class="modal-footer">
      <button type="button" class="btn btn-primary add_modifier" data-dismiss="modal">
        <?php echo app('translator')->getFromJson( 'messages.add' ); ?></button>
      <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo app('translator')->getFromJson( 'messages.close' ); ?></button>
    </div>

    <?php echo Form::close(); ?>


  </div><!-- /.modal-content -->
</div><!-- /.modal-dialog -->
</div>

<script type="text/javascript">
  $(document).ready(function(){
    $('div#<?php echo e($id); ?>').modal('show');
  });
</script>