<tr class="product_row">
    <td>
        <?php echo e($product->product_name); ?>

        <br/>
        <?php echo e($product->sub_sku); ?>

    </td>
    <td>
        
        <?php if(!empty($product->transaction_sell_lines_id)): ?>
            <input type="hidden" name="products[<?php echo e($row_index); ?>][transaction_sell_lines_id]" class="form-control" value="<?php echo e($product->transaction_sell_lines_id); ?>">
        <?php endif; ?>

        <input type="hidden" name="products[<?php echo e($row_index); ?>][product_id]" class="form-control product_id" value="<?php echo e($product->product_id); ?>">

        <input type="hidden" value="<?php echo e($product->variation_id); ?>" 
            name="products[<?php echo e($row_index); ?>][variation_id]">

        <input type="hidden" value="<?php echo e($product->enable_stock); ?>" 
            name="products[<?php echo e($row_index); ?>][enable_stock]">
        
        <?php if(empty($product->quantity_ordered)): ?>
            <?php
                $product->quantity_ordered = 1;
            ?>
        <?php endif; ?>

        <input type="text" class="form-control product_quantity input_number" value="<?php echo e(number_format($product->quantity_ordered, 2, session('currency')['decimal_separator'], session('currency')['thousand_separator'])); ?>" name="products[<?php echo e($row_index); ?>][quantity]" 
        <?php if($product->unit_allow_decimal == 1): ?> data-decimal=1 <?php else: ?> data-decimal=0 <?php endif; ?>
        data-rule-required="true" data-msg-required="<?php echo app('translator')->getFromJson('validation.custom-messages.this_field_is_required'); ?>" <?php if($product->enable_stock): ?> data-c-rule-max="<?php echo e($product->qty_available); ?>" data-msg-max="<?php echo app('translator')->getFromJson('validation.custom-messages.quantity_not_available', ['qty'=> $product->formatted_qty_available, 'unit' => $product->unit  ]); ?>" <?php endif; ?> >
        <?php echo e($product->unit); ?>

    </td>
    <td>
        <input type="text" name="products[<?php echo e($row_index); ?>][unit_price]" class="form-control product_unit_price input_number" value="<?php echo e(number_format($product->last_purchased_price, 2, session('currency')['decimal_separator'], session('currency')['thousand_separator'])); ?>">
    </td>
    <td>
        <input type="text" readonly name="products[<?php echo e($row_index); ?>][price]" class="form-control product_line_total" value="<?php echo e(number_format($product->quantity_ordered*$product->last_purchased_price, 2, session('currency')['decimal_separator'], session('currency')['thousand_separator'])); ?>">
    </td>
    <td class="text-center">
        <i class="fa fa-trash remove_product_row cursor-pointer" aria-hidden="true"></i>
    </td>
</tr>