//This file contains all functions used products tab

$(document).ready(function(){

	var product_table = $('#product_table').DataTable({
					processing: true,
					serverSide: true,
					ajax: '/products',
					columnDefs: [ {
						"targets": [0, 10],
						"orderable": false,
						"searchable": false
					} ],
					aaSorting: [[1, 'asc']],
					columns: [
							{ data: 'product_image', name: 'products.image'  },
					      { data: 'product', name: 'products.name'  },
					      { data: 'type', name: 'products.type'},
					      { data: 'category', name: 'c1.name'},
					      { data: 'sub_category', name: 'c2.name'},
					      { data: 'unit', name: 'units.actual_name'},
					      { data: 'brand', name: 'brands.name'},
					      { data: 'tax', name: 'tax_rates.name'},
					      { data: 'sku', name: 'products.sku'},
					      { data: 'alert_quantity', name: 'products.alert_quantity'},
					      { data: 'action', name: 'action'}
					    ],
                        createdRow: function( row, data, dataIndex ) {
                        	if($('input#is_rack_enabled').val() == 1){
                        		$( row ).find('td:eq(0) div').prepend('<i style="margin:auto;" class="fa fa-plus-circle text-success cursor-pointer no-print rack-details" title="' + LANG.details + '"></i>&nbsp;&nbsp;');
                        	}
                        }
			    });
	// Array to track the ids of the details displayed rows
    var detailRows = [];

	$('#product_table tbody').on( 'click', 'tr i.rack-details', function () {
		var i = $(this);
        var tr = $(this).closest('tr');
        var row = product_table.row( tr );
        var idx = $.inArray( tr.attr('id'), detailRows );

        if ( row.child.isShown() ) {
            i.addClass( 'fa-plus-circle text-success' );
            i.removeClass( 'fa-minus-circle text-danger' );

            row.child.hide();
 
            // Remove from the 'open' array
            detailRows.splice( idx, 1 );
        } else {
            i.removeClass( 'fa-plus-circle text-success' );
            i.addClass( 'fa-minus-circle text-danger' );

            row.child( get_product_details( row.data() ) ).show();
 
            // Add to the 'open' array
            if ( idx === -1 ) {
                detailRows.push( tr.attr('id') );
            }
        }
    });
		$(document).on('ifChecked', 'input#enable_stock', function(){
			$('div#alert_quantity_div').show();

			//Enable expiry selection
			if($('#expiry_period_type').length){
				$('#expiry_period_type').removeAttr("disabled");
			}

			if($('#opening_stock_button').length){
				$('#opening_stock_button').removeAttr("disabled");
			}
		}); 
		$(document).on('ifUnchecked', 'input#enable_stock', function(){
			$('div#alert_quantity_div').hide();
			$('input#alert_quantity').val(0);

			//Disable expiry selection
			if($('#expiry_period_type').length){
				$('#expiry_period_type').val('').change();
				$('#expiry_period_type').attr("disabled", true);
			}
			if($('#opening_stock_button').length){
				$('#opening_stock_button').attr("disabled", true);
			}
		});

	//Start For product type single

	//If purchase price exc tax is changed
	$(document).on( 'change', 'input#single_dpp', function(e){
		var purchase_exc_tax = __read_number($('input#single_dpp'));
		purchase_exc_tax = (purchase_exc_tax == undefined) ? 0 : purchase_exc_tax;

		var tax_rate = $('select#tax').find(':selected').data('rate');
		tax_rate = (tax_rate == undefined) ? 0 : tax_rate;

		var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
		__write_number($('input#single_dpp_inc_tax'), purchase_inc_tax);

		var profit_percent = __read_number($('#profit_percent'));
		var selling_price = __add_percent(purchase_exc_tax, profit_percent);
		__write_number($('input#single_dsp'), selling_price);

		var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
		__write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
	});

	//If tax rate is changed
	$(document).on( 'change', 'select#tax', function(){
		if($('select#type').val() == 'single'){
			var purchase_exc_tax = __read_number($('input#single_dpp'));
			purchase_exc_tax = (purchase_exc_tax == undefined) ? 0 : purchase_exc_tax;

			var tax_rate = $('select#tax').find(':selected').data('rate');
			tax_rate = (tax_rate == undefined) ? 0 : tax_rate;

			var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
			__write_number($('input#single_dpp_inc_tax'), purchase_inc_tax);

			var selling_price = __read_number($('input#single_dsp'));
			var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
			__write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
		}
	});

	//If purchase price inc tax is changed
	$(document).on( 'change', 'input#single_dpp_inc_tax', function(e){
		var purchase_inc_tax = __read_number($('input#single_dpp_inc_tax'));
		purchase_inc_tax = (purchase_inc_tax == undefined) ? 0 : purchase_inc_tax;

		var tax_rate = $('select#tax').find(':selected').data('rate');
		tax_rate = (tax_rate == undefined) ? 0 : tax_rate;

		var purchase_exc_tax = __get_principle(purchase_inc_tax, tax_rate);
		__write_number($('input#single_dpp'), purchase_exc_tax);

		var profit_percent = $('#profit_percent').val();
		var selling_price = __add_percent(purchase_exc_tax, profit_percent);
		__write_number($('input#single_dsp'), selling_price);

		var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
		__write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
	});

	$(document).on( 'change', 'input#profit_percent', function(e){
		var tax_rate = $('select#tax').find(':selected').data('rate');
		tax_rate = (tax_rate == undefined) ? 0 : tax_rate;

		var purchase_inc_tax = __read_number($('input#single_dpp_inc_tax'));
		purchase_inc_tax = (purchase_inc_tax == undefined) ? 0 : purchase_inc_tax;

		var purchase_exc_tax = __read_number($('input#single_dpp'));
		purchase_exc_tax = (purchase_exc_tax == undefined) ? 0 : purchase_exc_tax;

		var profit_percent = __read_number($('input#profit_percent'));
		var selling_price = __add_percent(purchase_exc_tax, profit_percent);
		__write_number($('input#single_dsp'), selling_price);

		var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
		__write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
	});

	$(document).on( 'change', 'input#single_dsp', function(e){
		var tax_rate = $('select#tax').find(':selected').data('rate');
		tax_rate = (tax_rate == undefined) ? 0 : tax_rate;

		var selling_price = __read_number($('input#single_dsp'));
		var purchase_exc_tax = __read_number($('input#single_dpp'));

		var profit_percent = __get_rate(purchase_exc_tax, selling_price);
		__write_number($('input#profit_percent'), profit_percent);

		var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
		__write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
	});

	$(document).on( 'change', 'input#single_dsp_inc_tax', function(e){
		var tax_rate = $('select#tax').find(':selected').data('rate');
		tax_rate = (tax_rate == undefined) ? 0 : tax_rate;
		var selling_price_inc_tax = __read_number($('input#single_dsp_inc_tax'));

		var selling_price = __get_principle( selling_price_inc_tax, tax_rate );
		__write_number($('input#single_dsp'), selling_price);

		var purchase_exc_tax = __read_number($('input#single_dpp'));
		var profit_percent = __get_rate(purchase_exc_tax, selling_price);
		__write_number($('input#profit_percent'), profit_percent);
	});

	$(document).on( 'click', '.submit_product_form', function(e){
        e.preventDefault();
        var submit_type = $(this).attr('value');
        $('#submit_type').val(submit_type);
        $("form#product_add_form").validate({
        	rules: {
			    sku: {
			      	remote: {
				        url: "/products/check_product_sku",
				        type: "post",
				        data: {
				          	sku: function() {
				            	return $( "#sku" ).val();
				          	},
				          	product_id: function() {
				            	if($('#product_id').length > 0 ){
				            		return $('#product_id').val();
				            	} else {
				            		return '';
				            	}
				          	}
				        }
				    }
			    },
			    expiry_period:{
	          		required: {
	          			depends: function(element) {
	          				return ($('#expiry_period_type').val().trim() != '');
	          			}
	          		}
	          	}
			},
			messages: {
				sku: {
					remote: LANG.sku_already_exists
				}
			}
        });
        if($("form#product_add_form").valid()) {
            $("form#product_add_form").submit();
        }
    });
    //End for product type single

    //Start for product type Variable
    //If purchase price exc tax is changed
	$(document).on( 'change', 'input.variable_dpp', function(e){

		var tr_obj = $(this).closest('tr');

		var purchase_exc_tax = __read_number($(this));
		purchase_exc_tax = (purchase_exc_tax == undefined) ? 0 : purchase_exc_tax;

		var tax_rate = $('select#tax').find(':selected').data('rate');
		tax_rate = (tax_rate == undefined) ? 0 : tax_rate;

		var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
		__write_number(tr_obj.find('input.variable_dpp_inc_tax'), purchase_inc_tax);

		var profit_percent = __read_number(tr_obj.find('input.variable_profit_percent'));
		var selling_price = __add_percent(purchase_exc_tax, profit_percent);
		__write_number(tr_obj.find('input.variable_dsp'), selling_price);

		var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
		__write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);
	});

	//If purchase price inc tax is changed
	$(document).on( 'change', 'input.variable_dpp_inc_tax', function(e){

		var tr_obj = $(this).closest('tr');

		var purchase_inc_tax = __read_number($(this));
		purchase_inc_tax = (purchase_inc_tax == undefined) ? 0 : purchase_inc_tax;

		var tax_rate = $('select#tax').find(':selected').data('rate');
		tax_rate = (tax_rate == undefined) ? 0 : tax_rate;

		var purchase_exc_tax = __get_principle(purchase_inc_tax, tax_rate);
		__write_number(tr_obj.find('input.variable_dpp'), purchase_exc_tax);

		var profit_percent = __read_number(tr_obj.find('input.variable_profit_percent'));
		var selling_price = __add_percent(purchase_exc_tax, profit_percent);
		__write_number(tr_obj.find('input.variable_dsp'), selling_price);

		var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
		__write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);
	});

	$(document).on( 'change', 'input.variable_profit_percent', function(e){
		var tax_rate = $('select#tax').find(':selected').data('rate');
		tax_rate = (tax_rate == undefined) ? 0 : tax_rate;

		var tr_obj = $(this).closest('tr');
		var profit_percent = __read_number($(this));

		var purchase_exc_tax = __read_number(tr_obj.find('input.variable_dpp'));
		purchase_exc_tax = (purchase_exc_tax == undefined) ? 0 : purchase_exc_tax;
		
		var selling_price = __add_percent(purchase_exc_tax, profit_percent);
		__write_number(tr_obj.find('input.variable_dsp'), selling_price);

		var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
		__write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);
	});

	$(document).on( 'change', 'input.variable_dsp', function(e){
		var tax_rate = $('select#tax').find(':selected').data('rate');
		tax_rate = (tax_rate == undefined) ? 0 : tax_rate;

		var tr_obj = $(this).closest('tr');
		var selling_price = __read_number($(this));
		var purchase_exc_tax = __read_number(tr_obj.find('input.variable_dpp'));

		var profit_percent = __get_rate(purchase_exc_tax, selling_price);
		__write_number(tr_obj.find('input.variable_profit_percent'), profit_percent);

		var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
		__write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);
	});
	$(document).on( 'change', 'input.variable_dsp_inc_tax', function(e){
		var tr_obj = $(this).closest('tr');
		var selling_price_inc_tax = __read_number($(this));

		var tax_rate = $('select#tax').find(':selected').data('rate');
		tax_rate = (tax_rate == undefined) ? 0 : tax_rate;

		var selling_price = __get_principle( selling_price_inc_tax, tax_rate);
		__write_number(tr_obj.find('input.variable_dsp'), selling_price);

		var purchase_exc_tax = __read_number(tr_obj.find('input.variable_dpp'));
		var profit_percent = __get_rate(purchase_exc_tax, selling_price);
		__write_number(tr_obj.find('input.variable_profit_percent'), profit_percent);
	});

	$(document).on( 'click', '.add_variation_value_row', function(){
        var variation_row_index = $(this).closest('.variation_row').find('.row_index').val();
        var variation_value_row_index = $(this).closest('table').find('tr:last .variation_row_index').val();

        if($(this).closest('.variation_row').find('.row_edit').length >=1){
        	var row_type = 'edit';
        }else{
        	var row_type = 'add';
        }

        var table = $(this).closest('table');

        $.ajax({
			method: "GET",
			url: '/products/get_variation_value_row',
            data: { 'variation_row_index': variation_row_index, 'value_index': variation_value_row_index, 'row_type': row_type},
			dataType: "html",
			success: function(result){
				if(result){
					table.append(result);
					toggle_dsp_input();
                }
			}
		});
    });

    $(document).on( 'change', '.variation_template', function(){
        tr_obj = $(this).closest('tr');

        if( $(this).val() !== ""){

        	tr_obj.find('input.variation_name').val($(this).find("option:selected" ).text());

            var template_id = $(this).val();
            var row_index = $(this).closest('tr').find('.row_index').val();
            $.ajax({
                method: "POST",
                url: '/products/get_variation_template',
                dataType: "html",
                data: { 'template_id': template_id, 'row_index': row_index},
                success: function(result){
                    if(result){
                        tr_obj.find('table.variation_value_table').find('tbody').html(result);
                        toggle_dsp_input();
                    }
                }
            });
        }
    });

    $(document).on( 'click', '.remove_variation_value_row', function(){
    	swal({
          title: LANG.sure,
          icon: "warning",
          buttons: true,
          dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
            	var count = $(this).closest('table').find('.remove_variation_value_row').length;
		        if( count === 1){
		            $(this).closest('.variation_row').remove();
		        } else {
		            $(this).closest('tr').remove();
		        }
            }
        });
    });

    //If tax rate is changed
	$(document).on( 'change', 'select#tax', function(){
		if($('select#type').val() == 'variable'){

			var tax_rate = $('select#tax').find(':selected').data('rate');
			tax_rate = (tax_rate == undefined) ? 0 : tax_rate;

			$('table.variation_value_table > tbody').each(function(){
				$(this).find('tr').each(function(){

					var purchase_exc_tax = __read_number($(this).find('input.variable_dpp'));
					purchase_exc_tax = (purchase_exc_tax == undefined) ? 0 : purchase_exc_tax;

					var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
					__write_number($(this).find('input.variable_dpp_inc_tax'), purchase_inc_tax);

					var selling_price = __read_number($(this).find('input.variable_dsp'));
					var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
					__write_number($(this).find('input.variable_dsp_inc_tax'), selling_price_inc_tax);
				});
			});
		}
	});
	//End for product type Variable
	$(document).on( 'change', '#tax_type', function(e){
		toggle_dsp_input();
	});
	toggle_dsp_input();

	$(document).on( 'change', '#expiry_period_type', function(e){
		if($(this).val()){
			$('input#expiry_period').prop('disabled', false)
		} else {
			$('input#expiry_period').val('');
			$('input#expiry_period').prop('disabled', true)
		}
	});

	$('table#product_table tbody').on('click', 'a.delete-product', function(e){
		e.preventDefault();
		swal({
          title: LANG.sure,
          icon: "warning",
          buttons: true,
          dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
            	var href = $(this).attr('href');
            	$.ajax({
					method: "DELETE",
					url: href,
					dataType: "json",
					success: function(result){
						if(result.success == true){
							toastr.success(result.msg);
							product_table.ajax.reload();
						} else {
							toastr.error(result.msg);
						}
					}
				});
            }
        });
	});

	$(document).on('click', 'a.view-product', function(e){
		e.preventDefault();
		$.ajax({
			url: $(this).attr("href"),
			dataType: "html",
			success: function(result){
				$('#view_product_modal').html(result).modal('show');
				__currency_convert_recursively($('#view_product_modal'));
			}
		});

	});
	var img_fileinput_setting = {'showUpload':false, 'showPreview':true, 'browseLabel': LANG.file_browse_label, 'removeLabel': LANG.remove, 'previewSettings': {
    image: {width: "auto", height: "auto", 'max-width': "100%", 'max-height': "100%"}} };
	$("#upload_image").fileinput(img_fileinput_setting);
});

function toggle_dsp_input(){
	var tax_type = $('#tax_type').val();
	if( tax_type == 'inclusive'){
		$('.dsp_label').each( function(){
			$(this).text(LANG.inc_tax);
		});
		$('#single_dsp').addClass('hide');
		$('#single_dsp_inc_tax').removeClass('hide');

		$('.add-product-price-table').find('.variable_dsp_inc_tax').each( function(){
			$(this).removeClass('hide');
		});
		$('.add-product-price-table').find('.variable_dsp').each( function(){
			$(this).addClass('hide');
		});
	} else if( tax_type == 'exclusive' ){
		$('.dsp_label').each( function(){
			$(this).text(LANG.exc_tax);
		});
		$('#single_dsp').removeClass('hide');
		$('#single_dsp_inc_tax').addClass('hide');

		$('.add-product-price-table').find('.variable_dsp_inc_tax').each( function(){
			$(this).addClass('hide');
		});
		$('.add-product-price-table').find('.variable_dsp').each( function(){
			$(this).removeClass('hide');
		});
	}
}

function get_product_details(rowData){
	var div = $('<div/>')
        .addClass( 'loading' )
        .text( 'Loading...' );

    $.ajax( {
        url: '/products/' + rowData.id,
        dataType: 'html',
        success: function ( data ) {
            div
                .html( data )
                .removeClass( 'loading' );
        }
    } );
 
    return div;
}