<?php

namespace App\Http\Controllers\Restaurant;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;

use App\Transaction;

use App\Utils\Util;

use App\Utils\RestaurantUtil;

class KitchenController extends Controller
{
    /**
     * All Utils instance.
     *
     */
    protected $commonUtil;
    protected $restUtil;

    /**
     * Constructor
     *
     * @param Util $commonUtil
     * @param RestaurantUtil $restUtil
     * @return void
     */
    public function __construct(Util $commonUtil, RestaurantUtil $restUtil)
    {
        $this->commonUtil = $commonUtil;
        $this->restUtil = $restUtil;
    }

    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        // if (!auth()->user()->can('sell.view')) {
        //     abort(403, 'Unauthorized action.');
        // }

        $business_id = request()->session()->get('user.business_id');
        $orders = $this->restUtil->getAllOrders($business_id, array('order_status' => 'received'));

        return view('restaurant.kitchen.index', compact('orders'));
    }

    /**
     * Marks an order as cooked
     * @return json $output
     */
    public function markAsCooked($id)
    {
        // if (!auth()->user()->can('sell.update')) {
        //     abort(403, 'Unauthorized action.');
        // }
        try {
            $business_id = request()->session()->get('user.business_id');
            $transaction = Transaction::where('business_id', $business_id)
                            ->where('type', 'sell')
                            ->find($id);
            if(!empty($transaction)){
                $transaction->res_order_status = 'cooked';
                $transaction->save();

                $output = array('success' => 1, 
                            'msg' => trans("restaurant.order_successfully_marked_cooked")
                        );
            } else {
                $output = array('success' => 0, 
                            'msg' => trans("messages.something_went_wrong")
                        );
            }

            
        } catch(\Exception $e){
            \Log::emergency("File:" . $e->getFile(). "Line:" . $e->getLine(). "Message:" . $e->getMessage());
            
            $output = array('success' => 0, 
                            'msg' => trans("messages.something_went_wrong")
                        );
        }

        return $output;
    }

    /**
     * Retrives fresh orders
     *
     * @return Json $output
     */
    public function refreshOrdersList(Request $request){

        // if (!auth()->user()->can('sell.view')) {
        //     abort(403, 'Unauthorized action.');
        // }
        $business_id = request()->session()->get('user.business_id');
        $orders_for = $request->orders_for;
        $filter = array();
        $service_staff_id = request()->session()->get('user.id');

        if(!$this->restUtil->is_service_staff($service_staff_id) && !empty($request->input('service_staff_id') )){
            $service_staff_id = $request->input('service_staff_id');
        }

        if($orders_for == 'kitchen'){
            $filter['order_status'] = 'received';  
        } elseif($orders_for == 'waiter'){
            $filter['waiter_id'] = $service_staff_id;  
        }
        
        $orders = $this->restUtil->getAllOrders($business_id, $filter);
        return view('restaurant.partials.show_orders', compact('orders', 'orders_for'));

    }

}
