<?php

namespace App\Http\Controllers\Restaurant;
use DB;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Yajra\DataTables\Facades\DataTables;
use Spatie\Permission\Models\Role;

use App\Restaurant\ResTable;

use App\BusinessLocation,
    App\Transaction,
    App\User;

use App\Utils\Util;

class DataController extends Controller
{
    /**
     * All Utils instance.
     *
     */
    protected $commonUtil;

    public function __construct(Util $commonUtil)
    {
        $this->commonUtil = $commonUtil;
    }

    /**
     * Show the restaurant module related details in pos screen.
     *
     * @return \Illuminate\Http\Response
     */
    public function getPosDetails(Request $request){
        if (request()->ajax()) {
            $business_id = $request->session()->get('user.business_id');
            $location_id = $request->get('location_id');
            if(!empty($location_id)){
                $transaction_id = $request->get('transaction_id', null);
                if(!empty($transaction_id)){
                    $transaction = Transaction::find($transaction_id);
                    $view_data = ['res_table_id' => $transaction->res_table_id,
                            'res_waiter_id' => $transaction->res_waiter_id,
                        ];
                } else {
                    $view_data = ['res_table_id' => null, 'res_waiter_id' => null];
                }

                //Get all service staff roles
                $service_staff_roles = Role::where('business_id', $business_id)
                                        ->where('is_service_staff', 1)
                                        ->get()
                                        ->pluck('name')
                                        ->toArray();

                $waiters_enabled = false;
                $tables_enabled = false;
                $waiters = null;
                $tables = null;
                if($this->commonUtil->isModuleEnabled('service_staff')){
                    $waiters_enabled = true;
                    $waiters = array();

                    //Get all users of service staff roles
                    if(!empty($service_staff_roles)){
                        $waiters = User::where('business_id', $business_id)->role($service_staff_roles)->get()->pluck('first_name', 'id');
                    }
                }
                if($this->commonUtil->isModuleEnabled('tables')){
                    $tables_enabled = true;
                    $tables = ResTable::where('business_id', $business_id)
                            ->where('location_id', $location_id)
                            ->pluck('name', 'id');
                }
            } else{
                $tables = array();
                $waiters = array();
                $waiters_enabled = $this->commonUtil->isModuleEnabled('service_staff') ? true : false;
                $tables_enabled = $this->commonUtil->isModuleEnabled('tables') ? true : false;
                $view_data = ['res_table_id' => null, 'res_waiter_id' => null];
            }

            return view('restaurant.partials.pos_table_dropdown')
                    ->with(compact('tables', 'waiters', 'view_data', 'waiters_enabled', 'tables_enabled'));
        }
    }

    /**
     * Save the pos screen details.
     *
     * @return null
     */
    public function sellPosStore($input){
        $table_id = request()->get('res_table_id');
        $res_waiter_id = request()->get('res_waiter_id');

        Transaction::where('id', $input['transaction_id'])
            ->where('type', 'sell')
            ->where('business_id', $input['business_id'])
            ->update(['res_table_id' => $table_id, 
                'res_waiter_id' => $res_waiter_id]);
    }
}
