<?php $__env->startSection('title', __('sale.products')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo app('translator')->getFromJson('sale.products'); ?>
        <small><?php echo app('translator')->getFromJson('lang_v1.manage_products'); ?></small>
    </h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content">

	<div class="box">
        <div class="box-header">
        	<h3 class="box-title"><?php echo app('translator')->getFromJson('lang_v1.all_products'); ?></h3>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.create')): ?>
            	<div class="box-tools">
                    <a class="btn btn-block btn-primary" href="<?php echo e(action('ProductController@create')); ?>">
    				<i class="fa fa-plus"></i> <?php echo app('translator')->getFromJson('messages.add'); ?></a>
                </div>
            <?php endif; ?>
        </div>
        <div class="box-body">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.view')): ?>
                <div class="table-responsive">
            	<table class="table table-bordered table-striped ajax_view table-text-center" id="product_table">
            		<thead>
            			<tr>
                            <th>&nbsp;</th>
            				<th><?php echo app('translator')->getFromJson('sale.product'); ?></th>
    						<th><?php echo app('translator')->getFromJson('product.product_type'); ?></th>
            				<th><?php echo app('translator')->getFromJson('product.category'); ?></th>
    						<th><?php echo app('translator')->getFromJson('product.sub_category'); ?></th>
                            <th><?php echo app('translator')->getFromJson('product.unit'); ?></th>
    						<th><?php echo app('translator')->getFromJson('product.brand'); ?></th>
    						<th><?php echo app('translator')->getFromJson('product.tax'); ?></th>
    						<th><?php echo app('translator')->getFromJson('product.sku'); ?></th>
    						<th><?php echo app('translator')->getFromJson('product.alert_quantity'); ?></th>
    						<th><?php echo app('translator')->getFromJson('messages.action'); ?></th>
            			</tr>
            		</thead>
            	</table>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <input type="hidden" id="is_rack_enabled" value="<?php echo e($rack_enabled); ?>">

    <div class="modal fade product_modal" tabindex="-1" role="dialog" 
    	aria-labelledby="gridSystemModalLabel">
    </div>

    <div class="modal fade" id="view_product_modal" tabindex="-1" role="dialog" 
        aria-labelledby="gridSystemModalLabel">
    </div>

    <div class="modal fade" id="opening_stock_modal" tabindex="-1" role="dialog" 
        aria-labelledby="gridSystemModalLabel">
    </div>

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src="<?php echo e(asset('js/product.js?v=' . $asset_v)); ?>"></script>
    <script src="<?php echo e(asset('js/opening_stock.js?v=' . $asset_v)); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>