<?php

use Illuminate\Database\Seeder;

use Illuminate\Support\Facades\DB;

use Illuminate\Database\Eloquent\Model;

use Spatie\Permission\Models\Role, 
	Spatie\Permission\Models\Permission;

use App\User;

class DummyBusinessSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::beginTransaction();

        $password = bcrypt('123456');

        $today = \Carbon::now()->format('Y-m-d H:i:s');
        $yesterday = \Carbon::now()->subDays(2)->format('Y-m-d H:i:s');
        $last_week = \Carbon::now()->subDays(7)->format('Y-m-d H:i:s');
        $last_15th_day = \Carbon::now()->subDays(15)->format('Y-m-d H:i:s');
        $last_month = \Carbon::now()->subDays(30)->format('Y-m-d H:i:s');

        $next_6_month = \Carbon::now()->addMonths(6)->format('Y-m-d');
        $next_12_month = \Carbon::now()->addMonths(12)->format('Y-m-d');
        $next_18_month = \Carbon::now()->addMonths(18)->format('Y-m-d');

        DB::statement("SET FOREIGN_KEY_CHECKS = 0");

         $shortcuts = '{"pos":{"express_checkout":"shift+e","pay_n_ckeckout":"shift+p","draft":"shift+d","cancel":"shift+c","edit_discount":"shift+i","edit_order_tax":"shift+t","add_payment_row":"shift+r","finalize_payment":"shift+f","recent_product_quantity":"f2","add_new_product":"f4"}}';

         $prefixes = '{"purchase":"PO","stock_transfer":"ST","stock_adjustment":"SA","sell_return":"CN","expense":"EP","contacts":"CO","purchase_payment":"PP","sell_payment":"SP","business_location":"BL"}';
        
$business = array(
  array('id' => '1','name' => 'Awesome Shop','currency_id' => '2','start_date' => '2018-01-01','tax_number_1' => '3412569900','tax_label_1' => 'GSTIN','tax_number_2' => NULL,'tax_label_2' => NULL,'default_sales_tax' => NULL,'default_profit_percent' => '25.00','owner_id' => '1','time_zone' => 'America/Phoenix','fy_start_month' => '1','accounting_method' => 'fifo','default_sales_discount' => '10.00','sell_price_tax' => 'includes','logo' => NULL,'sku_prefix' => 'AS','enable_product_expiry' => '0','expiry_type' => 'add_expiry','on_product_expiry' => 'keep_selling','stop_selling_before' => '0','enable_tooltip' => '1','purchase_in_diff_currency' => '0','purchase_currency_id' => NULL,'p_exchange_rate' => '1.000','transaction_edit_days' => '30','stock_expiry_alert_days' => '30','keyboard_shortcuts' => $shortcuts,'pos_settings' => NULL,'enable_brand' => '1','enable_category' => '1','enable_sub_category' => '1','enable_price_tax' => '1','enable_purchase_status' => '1','enable_lot_number' => '0','default_unit' => NULL,'enable_racks' => '0','enable_row' => '0','enable_position' => '0','enable_editing_product_from_purchase' => '1','sales_cmsn_agnt' => NULL,'item_addition_method' => '1','enable_inline_tax' => '1','currency_symbol_placement' => 'before','enabled_modules' => NULL,'date_format' => 'm/d/Y','time_format' => '24','ref_no_prefixes' => $prefixes,'created_at' => '2018-01-04 02:15:19','updated_at' => '2018-01-04 02:17:08'),
  array('id' => '2','name' => 'Awesome Pharmacy','currency_id' => '2','start_date' => '2018-04-10','tax_number_1' => '3412569900','tax_label_1' => 'VAT','tax_number_2' => NULL,'tax_label_2' => NULL,'default_sales_tax' => NULL,'default_profit_percent' => '25.00','owner_id' => '4','time_zone' => 'America/Chicago','fy_start_month' => '1','accounting_method' => 'fifo','default_sales_discount' => NULL,'sell_price_tax' => 'includes','logo' => NULL,'sku_prefix' => 'AP','enable_product_expiry' => '1','expiry_type' => 'add_manufacturing','on_product_expiry' => 'stop_selling','stop_selling_before' => '0','enable_tooltip' => '1','purchase_in_diff_currency' => '0','purchase_currency_id' => NULL,'p_exchange_rate' => '1.000','transaction_edit_days' => '30','stock_expiry_alert_days' => '30','keyboard_shortcuts' => $shortcuts,'pos_settings' => NULL,'enable_brand' => '1','enable_category' => '1','enable_sub_category' => '1','enable_price_tax' => '1','enable_purchase_status' => '1','enable_lot_number' => '0','default_unit' => '4','enable_racks' => '0','enable_row' => '0','enable_position' => '0','enable_editing_product_from_purchase' => '1','sales_cmsn_agnt' => NULL,'item_addition_method' => '1','enable_inline_tax' => '0','currency_symbol_placement' => 'before','enabled_modules' => NULL,'date_format' => 'm/d/Y','time_format' => '24','ref_no_prefixes' => $prefixes,'created_at' => '2018-04-10 08:12:40','updated_at' => '2018-04-10 10:21:38'),
  array('id' => '3','name' => 'Ultimate Electronics','currency_id' => '2','start_date' => '2018-04-10','tax_number_1' => '12548555003','tax_label_1' => 'GST','tax_number_2' => NULL,'tax_label_2' => NULL,'default_sales_tax' => NULL,'default_profit_percent' => '25.00','owner_id' => '5','time_zone' => 'America/Chicago','fy_start_month' => '1','accounting_method' => 'fifo','default_sales_discount' => NULL,'sell_price_tax' => 'includes','logo' => NULL,'sku_prefix' => 'AE','enable_product_expiry' => '0','expiry_type' => 'add_expiry','on_product_expiry' => 'keep_selling','stop_selling_before' => '0','enable_tooltip' => '1','purchase_in_diff_currency' => '0','purchase_currency_id' => NULL,'p_exchange_rate' => '1.000','transaction_edit_days' => '30','stock_expiry_alert_days' => '30','keyboard_shortcuts' => $shortcuts,'pos_settings' => NULL,'enable_brand' => '1','enable_category' => '1','enable_sub_category' => '1','enable_price_tax' => '1','enable_purchase_status' => '1','enable_lot_number' => '0','default_unit' => '5','enable_racks' => '0','enable_row' => '0','enable_position' => '0','enable_editing_product_from_purchase' => '1','sales_cmsn_agnt' => NULL,'item_addition_method' => '1','enable_inline_tax' => '0','currency_symbol_placement' => 'before','enabled_modules' => NULL,'date_format' => 'm/d/Y','time_format' => '24','ref_no_prefixes' => $prefixes,'created_at' => '2018-04-10 10:46:15','updated_at' => '2018-04-10 11:53:35'),
  array('id' => '4','name' => 'Awesome Services','currency_id' => '124','start_date' => NULL,'tax_number_1' => '3412569900','tax_label_1' => 'GST','tax_number_2' => NULL,'tax_label_2' => NULL,'default_sales_tax' => NULL,'default_profit_percent' => '25.00','owner_id' => '6','time_zone' => 'America/Chicago','fy_start_month' => '1','accounting_method' => 'fifo','default_sales_discount' => NULL,'sell_price_tax' => 'includes','logo' => NULL,'sku_prefix' => 'AS','enable_product_expiry' => '0','expiry_type' => 'add_expiry','on_product_expiry' => 'keep_selling','stop_selling_before' => '0','enable_tooltip' => '1','purchase_in_diff_currency' => '0','purchase_currency_id' => NULL,'p_exchange_rate' => '1.000','transaction_edit_days' => '30','stock_expiry_alert_days' => '30','keyboard_shortcuts' => $shortcuts,'pos_settings' => NULL,'enable_brand' => '0','enable_category' => '1','enable_sub_category' => '0','enable_price_tax' => '1','enable_purchase_status' => '1','enable_lot_number' => '0','default_unit' => NULL,'enable_racks' => '0','enable_row' => '0','enable_position' => '0','enable_editing_product_from_purchase' => '1','sales_cmsn_agnt' => NULL,'item_addition_method' => '1','enable_inline_tax' => '0','currency_symbol_placement' => 'before','enabled_modules' => NULL,'date_format' => 'm/d/Y','time_format' => '24','ref_no_prefixes' => $prefixes,'created_at' => '2018-04-10 12:20:42','updated_at' => '2018-04-10 12:23:40'),

  array('id' => '5','name' => 'Awesome Restaurant','currency_id' => '2','start_date' => '2018-07-12','tax_number_1' => '4578220005','tax_label_1' => 'IGST','tax_number_2' => '4593220009','tax_label_2' => 'SGST','default_sales_tax' => NULL,'default_profit_percent' => '25.00','owner_id' => '7','time_zone' => 'America/Chicago','fy_start_month' => '1','accounting_method' => 'fifo','default_sales_discount' => NULL,'sell_price_tax' => 'includes','logo' => NULL,'sku_prefix' => 'AR','enable_product_expiry' => '0','expiry_type' => 'add_expiry','on_product_expiry' => 'keep_selling','stop_selling_before' => '0','enable_tooltip' => '1','purchase_in_diff_currency' => '0','purchase_currency_id' => NULL,'p_exchange_rate' => '1.000','transaction_edit_days' => '30','stock_expiry_alert_days' => '30','keyboard_shortcuts' => $shortcuts,'pos_settings' => '{"disable_pay_checkout":0,"disable_draft":0,"disable_express_checkout":0,"hide_product_suggestion":0,"hide_recent_trans":0,"disable_discount":0,"disable_order_tax":0}','enable_brand' => '1','enable_category' => '1','enable_sub_category' => '1','enable_price_tax' => '1','enable_purchase_status' => '1','enable_lot_number' => '0','default_unit' => NULL,'enable_racks' => '0','enable_row' => '0','enable_position' => '0','enable_editing_product_from_purchase' => '1','sales_cmsn_agnt' => NULL,'item_addition_method' => '1','enable_inline_tax' => '0','currency_symbol_placement' => 'before','enabled_modules' => '["tables","modifiers","service_staff","kitchen"]','date_format' => 'm/d/Y','time_format' => '24','ref_no_prefixes' => $prefixes,'created_at' => '2018-07-13 16:42:11','updated_at' => '2018-07-13 07:38:24')
);
DB::table('business')->insert($business);

        DB::insert("INSERT INTO business_locations (id, business_id, name, landmark, country, state, city, zip_code, invoice_scheme_id, invoice_layout_id, print_receipt_on_invoice, receipt_printer_type, printer_id, mobile, alternate_number, email, deleted_at, created_at, updated_at) VALUES
					(1, 1, 'Awesome Shop', 'Linking Street', 'USA', 'Arizona', 'Phoenix', '85001', 1, 1, 1, 'browser', NULL, NULL, NULL, NULL, NULL, '2018-01-04 02:15:20', '2018-01-04 02:15:20'),
(2, 2, 'Awesome Pharmacy', 'Linking Street', 'USA', 'Arizona', 'Phoenix', '492001', 2, 2, 1, 'browser', NULL, '', '', '', NULL, '2018-04-10 08:12:40', '2018-04-10 08:12:40'),
(3, 3, 'Ultimate Electronics', 'Linking Street', 'USA', 'Arizona', 'Phoenix', '492001', 3, 3, 1, 'browser', NULL, '', '', '', NULL, '2018-04-10 10:46:16', '2018-04-10 10:46:16'),
(4, 4, 'Awesome Services', 'Linking Street', 'USA', 'Arizona', 'Phoenix', '282001', 4, 4, 1, 'browser', NULL, '', '', '', NULL, '2018-04-10 12:20:43', '2018-04-10 12:20:43'),
(5, 5, 'Awesome Restaurant', 'Linking Street', 'USA', 'Arizona', 'Phoenix', '85001', 5, 5, 1, 'browser', NULL, '', '', '', NULL, '2018-07-13 11:12:11', '2018-07-13 11:12:11')");

$cash_registers = array(
  array('id' => '1','business_id' => '5','user_id' => '7','status' => 'open','closed_at' => NULL,'closing_amount' => '0.00','total_card_slips' => '0','total_cheques' => '0','closing_note' => NULL,'created_at' => '2018-07-13 07:39:34','updated_at' => '2018-07-13 07:39:34')
);
DB::table('cash_registers')->insert($cash_registers);

// `pos`.`cash_register_transactions`
$cash_register_transactions = array(
  array('id' => '1','cash_register_id' => '1','amount' => '0.00','pay_method' => 'cash','type' => 'credit','transaction_type' => 'initial','transaction_id' => NULL,'created_at' => '2018-07-13 07:39:34','updated_at' => '2018-07-13 07:39:34'),
  array('id' => '2','cash_register_id' => '1','amount' => '42.50','pay_method' => 'cash','type' => 'credit','transaction_type' => 'sell','transaction_id' => '41','created_at' => '2018-07-13 07:44:40','updated_at' => '2018-07-13 07:44:40'),
  array('id' => '3','cash_register_id' => '1','amount' => '0.00','pay_method' => 'cash','type' => 'credit','transaction_type' => 'sell','transaction_id' => '41','created_at' => '2018-07-13 07:44:40','updated_at' => '2018-07-13 07:44:40'),
  array('id' => '4','cash_register_id' => '1','amount' => '77.50','pay_method' => 'cash','type' => 'credit','transaction_type' => 'sell','transaction_id' => '42','created_at' => '2018-07-13 07:45:29','updated_at' => '2018-07-13 07:45:29'),
  array('id' => '5','cash_register_id' => '1','amount' => '0.00','pay_method' => 'cash','type' => 'credit','transaction_type' => 'sell','transaction_id' => '42','created_at' => '2018-07-13 07:45:29','updated_at' => '2018-07-13 07:45:29'),
  array('id' => '6','cash_register_id' => '1','amount' => '33.75','pay_method' => 'cash','type' => 'credit','transaction_type' => 'sell','transaction_id' => '43','created_at' => '2018-07-13 07:46:04','updated_at' => '2018-07-13 07:46:04'),
  array('id' => '7','cash_register_id' => '1','amount' => '0.00','pay_method' => 'cash','type' => 'credit','transaction_type' => 'sell','transaction_id' => '43','created_at' => '2018-07-13 07:46:04','updated_at' => '2018-07-13 07:46:04'),
  array('id' => '8','cash_register_id' => '1','amount' => '71.25','pay_method' => 'cash','type' => 'credit','transaction_type' => 'sell','transaction_id' => '44','created_at' => '2018-07-13 07:46:36','updated_at' => '2018-07-13 07:46:36'),
  array('id' => '9','cash_register_id' => '1','amount' => '0.00','pay_method' => 'cash','type' => 'credit','transaction_type' => 'sell','transaction_id' => '44','created_at' => '2018-07-13 07:46:36','updated_at' => '2018-07-13 07:46:36')
);
DB::table('cash_register_transactions')->insert($cash_register_transactions);

        DB::insert("INSERT INTO users (id, surname, first_name, last_name, username, email, password, language, contact_no, address, remember_token, business_id, is_cmmsn_agnt, cmmsn_percent, deleted_at, created_at, updated_at) VALUES
					(1, 'Mr', 'Admin', NULL, 'admin', 'admin@example.com', '$password', 'en', NULL, NULL, '6wUbpN3xEjDDyQwCfHiGqO7JkIQgjYoDFeQMxcp09YQXq1Ih1e5EqydddBMz', 1, 0, '0.00', NULL, '2018-01-04 02:15:19', '2018-01-04 02:15:19'),
(2, 'Mr', 'Demo', 'Cashier', 'cashier', 'cashier@example.com', '$password', 'en', NULL, NULL, NULL, 1, 0, '0.00', NULL, '2018-01-04 02:20:58', '2018-01-04 02:20:58'),
(3, 'Mr.', 'Demo', 'Admin', 'demo-admin', 'demoadmin@example.com', '$password', 'en', NULL, NULL, NULL, 1, 0, '0.00', NULL, '2018-01-06 07:10:57', '2018-01-06 07:10:57'),
(4, 'Mr', 'Demo', 'Admin', 'admin-pharmacy', 'admin-pharma@example.com', '$password', 'en', NULL, NULL, 'MJnleh4kefXZtw3FCI2yHKEwr45Rs5nZxyQyGSFRfjIcQn93sJZyw7BAzSUq', 2, 0, '0.00', NULL, '2018-04-10 08:12:40', '2018-04-10 08:12:40'),
(5, 'Mr', 'Demo', 'Admin', 'admin-electronics', 'admin-electronics@example.com', '$password', 'en', NULL, NULL, 'YzGFoRAfllUjyB12qIZhowlteUPhvR1cd77YREQuqemSUftHp72aRLZMrzwR', 3, 0, '0.00', NULL, '2018-04-10 10:46:15', '2018-04-10 10:46:15'),
(6, 'Mr', 'Demo', 'Admin', 'admin-services', 'admin-services@example.com', '$password', 'en', NULL, NULL, 'CdBNjmTIXVU0nEgcEg85L97w6JEjvuE6CfF7mvhmz7Ad2K7IxJVd9WPLdxcg', 4, 0, '0.00', NULL, '2018-04-10 12:20:42', '2018-04-10 12:20:42'),
(7, 'Mr', 'Demo', 'Admin', 'admin-restaurant', 'admin-restaurant@example.com', '$password', 'en', NULL, NULL, 'ZzGDokwQe0vR0YpbBBWwbCWOGAkTgMS4wZlQOzAgWs2yAnovdGFkRwjofy1Y', 5, 0, '0.00', NULL, '2018-07-13 11:12:11', '2018-07-13 11:12:11'),
(8, 'Mr', 'Kevin', 'Nicols', 'kevin-nicols', 'kevin@example.com', '$password', 'en', NULL, NULL, '57dRoj3knI8dJ9UPSqFo2EH0CVTco5WJHnDgrmB2CY4lvJR6ZTtmzHi7NdLa', 5, 0, '0.00', NULL, '2018-07-13 02:13:20', '2018-07-13 02:13:20')");

        DB::insert("INSERT INTO brands (id, business_id, name, description, created_by, deleted_at, created_at, updated_at) VALUES
					(1, 1, 'Levis', NULL, 1, NULL, '2018-01-03 21:19:47', '2018-01-03 21:19:47'),
(2, 1, 'Espirit', NULL, 1, NULL, '2018-01-03 21:19:58', '2018-01-03 21:19:58'),
(3, 1, 'U.S. Polo Assn.', NULL, 1, NULL, '2018-01-03 21:20:26', '2018-01-03 21:20:26'),
(4, 1, 'Nike', NULL, 1, NULL, '2018-01-03 21:20:34', '2018-01-03 21:20:34'),
(5, 1, 'Puma', NULL, 1, NULL, '2018-01-03 21:20:40', '2018-01-03 21:20:40'),
(6, 1, 'Adidas', NULL, 1, NULL, '2018-01-03 21:20:46', '2018-01-03 21:20:46'),
(7, 1, 'Samsung', NULL, 1, NULL, '2018-01-06 05:40:14', '2018-01-06 05:40:14'),
(8, 1, 'Apple', NULL, 1, NULL, '2018-01-06 05:40:23', '2018-01-06 05:40:23'),
(9, 1, 'Acer', NULL, 1, NULL, '2018-01-06 06:03:37', '2018-01-06 06:03:37'),
(10, 1, 'Bowflex', NULL, 1, NULL, '2018-01-06 06:15:31', '2018-01-06 06:15:31'),
(11, 1, 'Oreo', NULL, 1, NULL, '2018-01-06 06:35:00', '2018-01-06 06:35:00'),
(12, 1, 'Sharewood', NULL, 1, NULL, '2018-01-06 06:40:52', '2018-01-06 06:40:52'),
(13, 1, 'Barilla', NULL, 1, NULL, '2018-01-06 06:44:59', '2018-01-06 06:44:59'),
(14, 1, 'Lipton', NULL, 1, NULL, '2018-01-06 06:48:12', '2018-01-06 06:48:12'),
(15, 2, 'Acino', NULL, 4, NULL, '2018-04-10 08:14:44', '2018-04-10 08:14:44'),
(16, 2, 'Cipla', NULL, 4, NULL, '2018-04-10 08:15:04', '2018-04-10 08:15:04'),
(17, 2, 'BAYER', NULL, 4, NULL, '2018-04-10 08:15:32', '2018-04-10 08:15:32'),
(18, 3, 'Samsung', NULL, 5, NULL, '2018-04-10 10:57:28', '2018-04-10 10:57:28'),
(19, 3, 'LG', NULL, 5, NULL, '2018-04-10 10:57:35', '2018-04-10 10:57:35'),
(20, 3, 'Apple', NULL, 5, NULL, '2018-04-10 10:57:42', '2018-04-10 10:57:42'),
(21, 3, 'Sony', NULL, 5, NULL, '2018-04-10 10:57:49', '2018-04-10 10:57:49'),
(22, 3, 'Panasonic', NULL, 5, NULL, '2018-04-10 10:57:57', '2018-04-10 10:57:57'),
(23, 3, 'HP', NULL, 5, NULL, '2018-04-10 11:07:21', '2018-04-10 11:07:21')");

        DB::insert("INSERT INTO categories (id, name, business_id, short_code, parent_id, created_by, deleted_at, created_at, updated_at) VALUES
					(1, 'Men''s', 1, NULL, 0, 1, NULL, '2018-01-03 21:06:34', '2018-01-03 21:06:34'),
(2, 'Women''s', 1, NULL, 0, 1, NULL, '2018-01-03 21:06:46', '2018-01-03 21:06:46'),
(3, 'Accessories', 1, NULL, 0, 1, NULL, '2018-01-03 21:07:03', '2018-01-03 21:07:03'),
(4, 'Jeans', 1, NULL, 1, 1, NULL, '2018-01-03 21:07:34', '2018-01-03 21:07:34'),
(5, 'Shirts', 1, NULL, 1, 1, NULL, '2018-01-03 21:08:18', '2018-01-03 21:08:18'),
(6, 'Belts', 1, NULL, 3, 1, NULL, '2018-01-03 21:08:41', '2018-01-03 21:08:41'),
(8, 'Shoes', 1, NULL, 3, 1, NULL, '2018-01-03 21:09:04', '2018-01-03 21:09:04'),
(10, 'Sandal', 1, NULL, 3, 1, NULL, '2018-01-03 21:09:23', '2018-01-03 21:09:23'),
(11, 'Wallets', 1, NULL, 3, 1, NULL, '2018-01-03 23:05:50', '2018-01-03 23:05:50'),
(12, 'Electronics', 1, NULL, 0, 1, NULL, '2018-01-06 05:24:34', '2018-01-06 05:24:34'),
(13, 'Cell Phones', 1, NULL, 12, 1, NULL, '2018-01-06 05:24:57', '2018-01-06 05:24:57'),
(14, 'Computers', 1, NULL, 12, 1, NULL, '2018-01-06 05:25:55', '2018-01-06 05:25:55'),
(15, 'Sports', 1, NULL, 0, 1, NULL, '2018-01-06 05:27:33', '2018-01-06 05:27:33'),
(16, 'Athletic Clothing', 1, NULL, 15, 1, NULL, '2018-01-06 05:28:40', '2018-01-06 05:28:40'),
(17, 'Exercise & Fitness', 1, NULL, 15, 1, NULL, '2018-01-06 05:29:19', '2018-01-06 05:29:19'),
(18, 'Books', 1, NULL, 0, 1, NULL, '2018-01-06 05:29:59', '2018-01-06 05:29:59'),
(19, 'Autobiography', 1, NULL, 18, 1, NULL, '2018-01-06 05:30:16', '2018-01-06 05:30:16'),
(20, 'Children''s books', 1, NULL, 18, 1, NULL, '2018-01-06 05:30:58', '2018-01-06 05:30:58'),
(21, 'Food & Grocery', 1, NULL, 0, 1, NULL, '2018-01-06 05:31:35', '2018-01-06 05:31:35'),
(22, 'Capsule', 2, NULL, 0, 4, NULL, '2018-04-10 08:19:58', '2018-04-10 08:20:54'),
(23, 'Bandages', 2, NULL, 0, 4, NULL, '2018-04-10 08:20:48', '2018-04-10 08:20:48'),
(24, 'Cream', 2, NULL, 0, 4, NULL, '2018-04-10 08:21:23', '2018-04-10 08:21:23'),
(25, 'Drops', 2, NULL, 0, 4, NULL, '2018-04-10 08:21:31', '2018-04-10 08:21:31'),
(26, 'Gel', 2, NULL, 0, 4, NULL, '2018-04-10 08:21:57', '2018-04-10 08:21:57'),
(27, 'Bottle', 2, NULL, 0, 4, NULL, '2018-04-10 08:22:30', '2018-04-10 08:22:30'),
(28, 'Mobile Phones', 3, NULL, 0, 5, NULL, '2018-04-10 10:59:49', '2018-04-10 10:59:49'),
(29, 'Tablets', 3, NULL, 0, 5, NULL, '2018-04-10 11:00:02', '2018-04-10 11:00:02'),
(30, 'Laptops', 3, NULL, 0, 5, NULL, '2018-04-10 11:00:09', '2018-04-10 11:00:09'),
(31, 'TVs', 3, NULL, 0, 5, NULL, '2018-04-10 11:00:15', '2018-04-10 11:00:15'),
(32, 'Cameras', 3, NULL, 0, 5, NULL, '2018-04-10 11:00:29', '2018-04-10 11:00:29'),
(33, 'Accessories', 3, NULL, 0, 5, NULL, '2018-04-10 11:00:57', '2018-04-10 11:00:57'),
(34, 'Car Services', 4, NULL, 0, 6, NULL, '2018-04-10 12:25:33', '2018-04-10 12:30:10'),
(35, 'Hair Styling', 4, NULL, 0, 6, NULL, '2018-04-10 12:28:32', '2018-04-10 12:29:18'),
(36, 'Plumbing', 4, NULL, 0, 6, NULL, '2018-04-10 12:30:41', '2018-04-10 12:30:41'),
(37, 'Bodycare', 4, NULL, 0, 6, NULL, '2018-04-10 12:30:52', '2018-04-10 12:30:52'),
(38, 'Spa', 4, NULL, 0, 6, NULL, '2018-04-10 12:31:01', '2018-04-10 12:31:01'),
(39, 'Starter', 5, NULL, 0, 7, NULL, '2018-07-13 00:49:08', '2018-07-13 00:49:08'),
(40, 'Main Menu', 5, NULL, 0, 7, NULL, '2018-07-13 00:49:24', '2018-07-13 00:49:24'),
(41, 'Salad', 5, NULL, 0, 7, NULL, '2018-07-13 00:50:15', '2018-07-13 00:50:15'),
(42, 'Pizza', 5, NULL, 0, 7, NULL, '2018-07-13 00:50:29', '2018-07-13 00:50:29'),
(43, 'Desserts', 5, NULL, 0, 7, NULL, '2018-07-13 00:50:40', '2018-07-13 00:50:40'),
(44, 'Drinks', 5, NULL, 0, 7, NULL, '2018-07-13 00:50:54', '2018-07-13 00:50:54'),
(45, 'Bakery and Snacks', 5, NULL, 0, 7, NULL, '2018-07-13 01:58:40', '2018-07-13 01:58:40')");

$contacts = array(
  array('id' => '1','business_id' => '1','type' => 'customer','supplier_business_name' => NULL,'name' => 'Walk-In Customer','email' => NULL,'contact_id' => 'CO0005','tax_number' => NULL,'city' => 'Phoenix','state' => 'Arizona','country' => 'USA','landmark' => 'Linking Street','mobile' => '(378) 400-1234','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => NULL,'pay_term_type' => NULL,'created_by' => '1','is_default' => '1','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-01-03 20:45:20','updated_at' => '2018-06-11 22:22:05'),
  array('id' => '2','business_id' => '1','type' => 'supplier','supplier_business_name' => 'Alpha Clothings','name' => 'Michael','email' => NULL,'contact_id' => 'CO0001','tax_number' => '4590091535','city' => 'Phoenix','state' => 'Arizona','country' => 'USA','landmark' => 'Linking Street','mobile' => '(378) 400-1234','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => '15','pay_term_type' => 'days','created_by' => '1','is_default' => '0','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-01-03 20:59:38','updated_at' => '2018-06-11 22:21:03'),
  array('id' => '3','business_id' => '1','type' => 'supplier','supplier_business_name' => 'Manhattan Clothing Ltd.','name' => 'Philip','email' => NULL,'contact_id' => 'CO0003','tax_number' => '54869310093','city' => 'Phoenix','state' => 'Arizona','country' => 'USA','landmark' => 'Linking Street','mobile' => '(378) 400-1234','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => '15','pay_term_type' => 'days','created_by' => '1','is_default' => '0','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-01-03 21:00:55','updated_at' => '2018-06-11 22:21:36'),
  array('id' => '4','business_id' => '1','type' => 'customer','supplier_business_name' => NULL,'name' => 'Harry','email' => NULL,'contact_id' => 'CO0006','tax_number' => NULL,'city' => 'Phoenix','state' => 'Arizona','country' => 'USA','landmark' => 'Linking Street','mobile' => '(378) 400-1234','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => NULL,'pay_term_type' => NULL,'created_by' => '1','is_default' => '0','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-01-03 21:01:40','updated_at' => '2018-06-11 22:22:16'),
  array('id' => '5','business_id' => '1','type' => 'supplier','supplier_business_name' => 'Digital Ocean','name' => 'Mike McCubbin','email' => NULL,'contact_id' => 'CN0004','tax_number' => '52965489001','city' => 'Phoenix','state' => 'Arizona','country' => 'USA','landmark' => 'Linking Street','mobile' => '(378) 400-1234','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => '30','pay_term_type' => 'days','created_by' => '1','is_default' => '0','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-01-06 06:53:22','updated_at' => '2018-06-11 22:21:47'),
  array('id' => '6','business_id' => '1','type' => 'supplier','supplier_business_name' => 'Univer Suppliers','name' => 'Jackson Hill','email' => NULL,'contact_id' => 'CO0002','tax_number' => '5459000655','city' => 'Phoenix','state' => 'Arizona','country' => 'USA','landmark' => 'Linking Street','mobile' => '(378) 400-1234','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => '45','pay_term_type' => 'days','created_by' => '1','is_default' => '0','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-01-06 06:55:09','updated_at' => '2018-06-11 22:21:18'),
  array('id' => '7','business_id' => '2','type' => 'customer','supplier_business_name' => NULL,'name' => 'Walk-In Customer','email' => NULL,'contact_id' => NULL,'tax_number' => NULL,'city' => NULL,'state' => NULL,'country' => NULL,'landmark' => NULL,'mobile' => '','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => NULL,'pay_term_type' => NULL,'created_by' => '4','is_default' => '1','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-04-10 08:12:40','updated_at' => '2018-04-10 08:12:40'),
  array('id' => '8','business_id' => '2','type' => 'supplier','supplier_business_name' => 'Jones Pharma','name' => 'Micheal Larson','email' => NULL,'contact_id' => '522500003','tax_number' => NULL,'city' => 'Phoenix','state' => 'Arizona','country' => 'USA','landmark' => NULL,'mobile' => '(378) 400-1234','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => '30','pay_term_type' => 'days','created_by' => '4','is_default' => '0','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-04-10 10:02:52','updated_at' => '2018-04-10 10:02:52'),
  array('id' => '9','business_id' => '2','type' => 'supplier','supplier_business_name' => 'Axolotl Biologix','name' => 'Phillip Jenner','email' => NULL,'contact_id' => '4585220005','tax_number' => NULL,'city' => 'Phoenix','state' => 'Arizona','country' => 'USA','landmark' => NULL,'mobile' => '(378) 400-1234','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => '30','pay_term_type' => 'days','created_by' => '4','is_default' => '0','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-04-10 10:04:20','updated_at' => '2018-04-10 10:04:20'),
  array('id' => '10','business_id' => '3','type' => 'customer','supplier_business_name' => NULL,'name' => 'Walk-In Customer','email' => NULL,'contact_id' => NULL,'tax_number' => NULL,'city' => NULL,'state' => NULL,'country' => NULL,'landmark' => NULL,'mobile' => '','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => NULL,'pay_term_type' => NULL,'created_by' => '5','is_default' => '1','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-04-10 10:46:16','updated_at' => '2018-04-10 10:46:16'),
  array('id' => '11','business_id' => '3','type' => 'supplier','supplier_business_name' => 'Digital Ocean','name' => 'Micheal Krick','email' => NULL,'contact_id' => '12500079','tax_number' => NULL,'city' => 'Phoenix','state' => 'Arizona','country' => 'USA','landmark' => NULL,'mobile' => '(378) 400-1234','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => '30','pay_term_type' => 'days','created_by' => '5','is_default' => '0','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-04-10 11:36:21','updated_at' => '2018-04-10 11:36:21'),
  array('id' => '12','business_id' => '3','type' => 'supplier','supplier_business_name' => 'Neon Electronics','name' => 'Samuel Williams','email' => NULL,'contact_id' => '525800083','tax_number' => NULL,'city' => 'Phoenix','state' => 'Arizona','country' => 'USA','landmark' => NULL,'mobile' => '(378) 400-1234','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => '30','pay_term_type' => 'days','created_by' => '5','is_default' => '0','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-04-10 11:38:33','updated_at' => '2018-04-10 11:38:33'),
  array('id' => '13','business_id' => '4','type' => 'customer','supplier_business_name' => NULL,'name' => 'Walk-In Customer','email' => NULL,'contact_id' => NULL,'tax_number' => NULL,'city' => NULL,'state' => NULL,'country' => NULL,'landmark' => NULL,'mobile' => '','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => NULL,'pay_term_type' => NULL,'created_by' => '6','is_default' => '1','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-04-10 12:20:43','updated_at' => '2018-04-10 12:20:43'),
  array('id' => '14','business_id' => '5','type' => 'customer','supplier_business_name' => NULL,'name' => 'Walk-In Customer','email' => NULL,'contact_id' => 'CO0001','tax_number' => NULL,'city' => NULL,'state' => NULL,'country' => NULL,'landmark' => NULL,'mobile' => '','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => NULL,'pay_term_type' => NULL,'created_by' => '7','is_default' => '1','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-07-13 16:42:11','updated_at' => '2018-07-13 16:42:11'),
  array('id' => '15','business_id' => '5','type' => 'supplier','supplier_business_name' => 'Perfect Bakers','name' => 'Thomas Willson','email' => 'thomas@example.com','contact_id' => 'CO0002','tax_number' => '45781005','city' => NULL,'state' => NULL,'country' => NULL,'landmark' => NULL,'mobile' => '87850009358','landline' => NULL,'alternate_number' => NULL,'pay_term_number' => '10','pay_term_type' => 'months','created_by' => '7','is_default' => '0','customer_group_id' => NULL,'custom_field1' => NULL,'custom_field2' => NULL,'custom_field3' => NULL,'custom_field4' => NULL,'deleted_at' => NULL,'created_at' => '2018-07-13 07:33:50','updated_at' => '2018-07-13 07:33:50')
);
DB::table('contacts')->insert($contacts);

$reference_counts = array(
  array('id' => '1','ref_type' => 'purchase','ref_count' => '1','business_id' => '1','created_at' => '2018-06-11 22:17:07','updated_at' => '2018-06-11 22:17:07'),
  array('id' => '2','ref_type' => 'contacts','ref_count' => '6','business_id' => '1','created_at' => '2018-06-11 22:17:07','updated_at' => '2018-06-11 22:17:07'),
  array('id' => '3','ref_type' => 'contacts','ref_count' => '2','business_id' => '5','created_at' => '2018-07-13 16:42:11','updated_at' => '2018-07-13 07:33:50'),
  array('id' => '4','ref_type' => 'business_location','ref_count' => '1','business_id' => '5','created_at' => '2018-07-13 16:42:11','updated_at' => '2018-07-13 16:42:11'),
  array('id' => '5','ref_type' => 'purchase','ref_count' => '2','business_id' => '5','created_at' => '2018-07-13 07:34:45','updated_at' => '2018-07-13 07:38:24'),
  array('id' => '6','ref_type' => 'sell_payment','ref_count' => '4','business_id' => '5','created_at' => '2018-07-13 07:44:40','updated_at' => '2018-07-13 07:46:36')
);
DB::table('reference_counts')->insert($reference_counts);

$res_tables = array(
  array('id' => '1','business_id' => '5','location_id' => '5','name' => 'Table 1','description' => NULL,'created_by' => '7','deleted_at' => NULL,'created_at' => '2018-07-13 07:40:57','updated_at' => '2018-07-13 07:40:57'),
  array('id' => '2','business_id' => '5','location_id' => '5','name' => 'Table 2','description' => NULL,'created_by' => '7','deleted_at' => NULL,'created_at' => '2018-07-13 07:41:04','updated_at' => '2018-07-13 07:41:04'),
  array('id' => '3','business_id' => '5','location_id' => '5','name' => 'Table 3','description' => NULL,'created_by' => '7','deleted_at' => NULL,'created_at' => '2018-07-13 07:41:10','updated_at' => '2018-07-13 07:41:10'),
  array('id' => '4','business_id' => '5','location_id' => '5','name' => 'Table 4','description' => NULL,'created_by' => '7','deleted_at' => NULL,'created_at' => '2018-07-13 07:41:17','updated_at' => '2018-07-13 07:41:17')
);

DB::table('res_tables')->insert($res_tables);

        DB::insert("INSERT INTO tax_rates (id, business_id, name, amount, is_tax_group, created_by, deleted_at, created_at, updated_at) VALUES
					(1, 1, 'VAT@10%', 10.00, 0, 1, NULL, '2018-01-04 02:40:07', '2018-01-04 02:40:07'),
(2, 1, 'CGST@10%', 10.00, 0, 1, NULL, '2018-01-04 02:40:55', '2018-01-04 02:40:55'),
(3, 1, 'SGST@8%', 8.00, 0, 1, NULL, '2018-01-04 02:41:13', '2018-01-04 02:41:13'),
(4, 1, 'GST@18%', 18.00, 1, 1, NULL, '2018-01-04 02:42:19', '2018-01-04 02:42:19')");

        DB::insert("INSERT INTO group_sub_taxes (group_tax_id, tax_id) VALUES
					(4, 2),
					(4, 3)");

        DB::insert("INSERT INTO invoice_schemes (id, business_id, name, scheme_type, prefix, start_number, invoice_count, total_digits, is_default, created_at, updated_at) VALUES
					(1, 1, 'Default', 'blank', 'AS', 1, 5, 4, 1, '2018-01-04 02:15:20', '2018-01-04 02:45:16'),
(2, 2, 'Default', 'blank', 'AP', 1, 3, 4, 1, '2018-04-10 08:12:40', '2018-04-10 10:26:12'),
(3, 3, 'Default', 'blank', 'AE', 1, 5, 4, 1, '2018-04-10 10:46:16', '2018-04-10 11:54:16'),
(4, 4, 'Default', 'blank', '', 1, 8, 4, 1, '2018-04-10 12:20:43', '2018-04-10 13:08:49'),
(5, 5, 'Default', 'blank', '', 1, 4, 4, 1, '2018-07-13 11:12:11', '2018-07-13 02:16:36')");

$invoice_layouts = array(
  array('id' => '1','name' => 'Default','header_text' => NULL,'invoice_no_prefix' => 'Invoice No.','quotation_no_prefix' => NULL,'invoice_heading' => 'Invoice','sub_heading_line1' => NULL,'sub_heading_line2' => NULL,'sub_heading_line3' => NULL,'sub_heading_line4' => NULL,'sub_heading_line5' => NULL,'invoice_heading_not_paid' => '','invoice_heading_paid' => '','quotation_heading' => NULL,'sub_total_label' => 'Subtotal','discount_label' => 'Discount','tax_label' => 'Tax','total_label' => 'Total','total_due_label' => 'Total Due','paid_label' => 'Total Paid','show_client_id' => '0','client_id_label' => NULL,'client_tax_label' => NULL,'date_label' => 'Date','show_time' => '1','show_brand' => '0','show_sku' => '1','show_cat_code' => '1','show_sale_description' => '0','table_product_label' => 'Product','table_qty_label' => 'Quantity','table_unit_price_label' => 'Unit Price','table_subtotal_label' => 'Subtotal','cat_code_label' => NULL,'logo' => NULL,'show_logo' => '0','show_business_name' => '0','show_location_name' => '1','show_landmark' => '1','show_city' => '1','show_state' => '1','show_zip_code' => '1','show_country' => '1','show_mobile_number' => '1','show_alternate_number' => '0','show_email' => '0','show_tax_1' => '1','show_tax_2' => '0','show_barcode' => '0','show_payments' => '1','show_customer' => '1','customer_label' => 'Customer','highlight_color' => '#000000','footer_text' => '','module_info' => NULL,'is_default' => '1','business_id' => '1','design' => 'classic','cn_heading' => NULL,'cn_no_label' => NULL,'cn_amount_label' => NULL,'created_at' => '2018-04-03 23:35:32','updated_at' => '2018-04-03 23:35:32'),
  array('id' => '2','name' => 'Default','header_text' => NULL,'invoice_no_prefix' => 'Invoice No.','quotation_no_prefix' => NULL,'invoice_heading' => 'Invoice','sub_heading_line1' => NULL,'sub_heading_line2' => NULL,'sub_heading_line3' => NULL,'sub_heading_line4' => NULL,'sub_heading_line5' => NULL,'invoice_heading_not_paid' => '','invoice_heading_paid' => '','quotation_heading' => NULL,'sub_total_label' => 'Subtotal','discount_label' => 'Discount','tax_label' => 'Tax','total_label' => 'Total','total_due_label' => 'Total Due','paid_label' => 'Total Paid','show_client_id' => '0','client_id_label' => NULL,'client_tax_label' => NULL,'date_label' => 'Date','show_time' => '1','show_brand' => '0','show_sku' => '1','show_cat_code' => '1','show_sale_description' => '0','table_product_label' => 'Product','table_qty_label' => 'Quantity','table_unit_price_label' => 'Unit Price','table_subtotal_label' => 'Subtotal','cat_code_label' => NULL,'logo' => NULL,'show_logo' => '0','show_business_name' => '0','show_location_name' => '1','show_landmark' => '1','show_city' => '1','show_state' => '1','show_zip_code' => '1','show_country' => '1','show_mobile_number' => '1','show_alternate_number' => '0','show_email' => '0','show_tax_1' => '1','show_tax_2' => '0','show_barcode' => '0','show_payments' => '1','show_customer' => '1','customer_label' => 'Customer','highlight_color' => '#000000','footer_text' => '','module_info' => NULL,'is_default' => '1','business_id' => '2','design' => 'classic','cn_heading' => NULL,'cn_no_label' => NULL,'cn_amount_label' => NULL,'created_at' => '2018-04-10 08:12:40','updated_at' => '2018-04-10 08:12:40'),
  array('id' => '3','name' => 'Default','header_text' => NULL,'invoice_no_prefix' => 'Invoice No.','quotation_no_prefix' => NULL,'invoice_heading' => 'Invoice','sub_heading_line1' => NULL,'sub_heading_line2' => NULL,'sub_heading_line3' => NULL,'sub_heading_line4' => NULL,'sub_heading_line5' => NULL,'invoice_heading_not_paid' => '','invoice_heading_paid' => '','quotation_heading' => NULL,'sub_total_label' => 'Subtotal','discount_label' => 'Discount','tax_label' => 'Tax','total_label' => 'Total','total_due_label' => 'Total Due','paid_label' => 'Total Paid','show_client_id' => '0','client_id_label' => NULL,'client_tax_label' => NULL,'date_label' => 'Date','show_time' => '1','show_brand' => '0','show_sku' => '1','show_cat_code' => '1','show_sale_description' => '0','table_product_label' => 'Product','table_qty_label' => 'Quantity','table_unit_price_label' => 'Unit Price','table_subtotal_label' => 'Subtotal','cat_code_label' => NULL,'logo' => NULL,'show_logo' => '0','show_business_name' => '0','show_location_name' => '1','show_landmark' => '1','show_city' => '1','show_state' => '1','show_zip_code' => '1','show_country' => '1','show_mobile_number' => '1','show_alternate_number' => '0','show_email' => '0','show_tax_1' => '1','show_tax_2' => '0','show_barcode' => '0','show_payments' => '1','show_customer' => '1','customer_label' => 'Customer','highlight_color' => '#000000','footer_text' => '','module_info' => NULL,'is_default' => '1','business_id' => '3','design' => 'classic','cn_heading' => NULL,'cn_no_label' => NULL,'cn_amount_label' => NULL,'created_at' => '2018-04-10 10:46:16','updated_at' => '2018-04-10 10:46:16'),
  array('id' => '4','name' => 'Default','header_text' => NULL,'invoice_no_prefix' => 'Invoice No.','quotation_no_prefix' => NULL,'invoice_heading' => 'Invoice','sub_heading_line1' => NULL,'sub_heading_line2' => NULL,'sub_heading_line3' => NULL,'sub_heading_line4' => NULL,'sub_heading_line5' => NULL,'invoice_heading_not_paid' => '','invoice_heading_paid' => '','quotation_heading' => NULL,'sub_total_label' => 'Subtotal','discount_label' => 'Discount','tax_label' => 'Tax','total_label' => 'Total','total_due_label' => 'Total Due','paid_label' => 'Total Paid','show_client_id' => '0','client_id_label' => NULL,'client_tax_label' => NULL,'date_label' => 'Date','show_time' => '1','show_brand' => '0','show_sku' => '1','show_cat_code' => '1','show_sale_description' => '0','table_product_label' => 'Product','table_qty_label' => 'Quantity','table_unit_price_label' => 'Unit Price','table_subtotal_label' => 'Subtotal','cat_code_label' => NULL,'logo' => NULL,'show_logo' => '0','show_business_name' => '0','show_location_name' => '1','show_landmark' => '1','show_city' => '1','show_state' => '1','show_zip_code' => '1','show_country' => '1','show_mobile_number' => '1','show_alternate_number' => '0','show_email' => '0','show_tax_1' => '1','show_tax_2' => '0','show_barcode' => '0','show_payments' => '1','show_customer' => '1','customer_label' => 'Customer','highlight_color' => '#000000','footer_text' => '','module_info' => NULL,'is_default' => '1','business_id' => '4','design' => 'classic','cn_heading' => NULL,'cn_no_label' => NULL,'cn_amount_label' => NULL,'created_at' => '2018-04-10 12:20:43','updated_at' => '2018-04-10 12:20:43'),
  array('id' => '5','name' => 'Default','header_text' => NULL,'invoice_no_prefix' => 'Invoice No.','quotation_no_prefix' => NULL,'invoice_heading' => 'Invoice','sub_heading_line1' => NULL,'sub_heading_line2' => NULL,'sub_heading_line3' => NULL,'sub_heading_line4' => NULL,'sub_heading_line5' => NULL,'invoice_heading_not_paid' => '','invoice_heading_paid' => '','quotation_heading' => NULL,'sub_total_label' => 'Subtotal','discount_label' => 'Discount','tax_label' => 'Tax','total_label' => 'Total','total_due_label' => 'Total Due','paid_label' => 'Total Paid','show_client_id' => '0','client_id_label' => NULL,'client_tax_label' => NULL,'date_label' => 'Date','show_time' => '1','show_brand' => '0','show_sku' => '1','show_cat_code' => '1','show_sale_description' => '0','table_product_label' => 'Product','table_qty_label' => 'Quantity','table_unit_price_label' => 'Unit Price','table_subtotal_label' => 'Subtotal','cat_code_label' => NULL,'logo' => NULL,'show_logo' => '0','show_business_name' => '0','show_location_name' => '1','show_landmark' => '1','show_city' => '1','show_state' => '1','show_zip_code' => '1','show_country' => '1','show_mobile_number' => '1','show_alternate_number' => '0','show_email' => '0','show_tax_1' => '1','show_tax_2' => '0','show_barcode' => '0','show_payments' => '1','show_customer' => '1','customer_label' => 'Customer','highlight_color' => '#000000','footer_text' => '','module_info' => NULL,'is_default' => '1','business_id' => '5','design' => 'classic','cn_heading' => NULL,'cn_no_label' => NULL,'cn_amount_label' => NULL,'created_at' => '2018-07-13 16:42:11','updated_at' => '2018-07-13 16:42:11')
);
DB::table('invoice_layouts')->insert($invoice_layouts);

        DB::insert("INSERT INTO units (id, business_id, actual_name, short_name, allow_decimal, created_by, deleted_at, created_at, updated_at) VALUES
					(1, 1, 'Pieces', 'Pc(s)', 0, 1, NULL, '2018-01-03 20:45:20', '2018-01-03 20:45:20'),
(2, 1, 'Packets', 'packets', 0, 1, NULL, '2018-01-06 06:37:01', '2018-01-06 06:38:36'),
(3, 1, 'Grams', 'g', 1, 1, NULL, '2018-01-06 06:40:34', '2018-01-06 06:40:34'),
(4, 2, 'Pieces', 'Pc(s)', 0, 4, NULL, '2018-04-10 08:12:40', '2018-04-10 08:12:40'),
(5, 3, 'Units', 'units', 0, 5, NULL, '2018-04-10 10:46:16', '2018-04-10 10:59:19'),
(6, 4, 'Units', 'units', 0, 6, NULL, '2018-04-10 12:20:43', '2018-04-10 12:32:04'),
(7, 5, 'Pieces', 'Pc(s)', 0, 7, NULL, '2018-07-13 11:12:11', '2018-07-13 11:12:11'),
(8, 5, 'Packets', 'packets', 0, 7, NULL, '2018-07-13 01:57:16', '2018-07-13 01:57:16')");

$products = array(
  array('id' => '1','name' => 'Men\'s Reverse Fleece Crew','business_id' => '1','type' => 'single','unit_id' => '1','brand_id' => '1','category_id' => '1','sub_category_id' => '5','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '5','sku' => 'AS0001','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528728059_fleece_crew.jpg','created_by' => '1','created_at' => '2018-01-03 21:29:08','updated_at' => '2018-06-11 07:40:59'),
  array('id' => '2','name' => 'Levis Men\'s Slimmy Fit Jeans','business_id' => '1','type' => 'variable','unit_id' => '1','brand_id' => '1','category_id' => '1','sub_category_id' => '4','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '10','sku' => 'AS0002','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528727964_levis_jeans.jpg','created_by' => '1','created_at' => '2018-01-03 21:30:35','updated_at' => '2018-06-11 07:39:24'),
  array('id' => '3','name' => 'Men\'s Cozy Hoodie Sweater','business_id' => '1','type' => 'variable','unit_id' => '1','brand_id' => '2','category_id' => '1','sub_category_id' => '5','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '10','sku' => 'AS0003','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528728035_cozy_sweater.jpg','created_by' => '1','created_at' => '2018-01-03 22:51:52','updated_at' => '2018-06-11 07:40:35'),
  array('id' => '4','name' => 'Puma Brown Sneaker','business_id' => '1','type' => 'variable','unit_id' => '1','brand_id' => '5','category_id' => '3','sub_category_id' => '8','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '5','sku' => 'AS0004','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528728147_puma_brown_sneaker.jpg','created_by' => '1','created_at' => '2018-01-03 22:54:33','updated_at' => '2018-06-11 07:42:27'),
  array('id' => '8','name' => 'Nike Fashion Sneaker','business_id' => '1','type' => 'variable','unit_id' => '1','brand_id' => '4','category_id' => '3','sub_category_id' => '8','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '10','sku' => 'AS0008','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528728076_nike_sneaker.jpg','created_by' => '1','created_at' => '2018-01-03 23:10:10','updated_at' => '2018-06-11 07:41:16'),
  array('id' => '9','name' => 'PUMA Men\'s Black Sneaker','business_id' => '1','type' => 'variable','unit_id' => '1','brand_id' => '5','category_id' => '3','sub_category_id' => '8','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '10','sku' => 'AS0009','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528728163_puma_brown_sneaker.jpg','created_by' => '1','created_at' => '2018-01-03 23:11:57','updated_at' => '2018-06-11 07:42:43'),
  array('id' => '10','name' => 'NIKE Men\'s Running Shoe','business_id' => '1','type' => 'variable','unit_id' => '1','brand_id' => '4','category_id' => '3','sub_category_id' => '8','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '10','sku' => 'AS0010','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528728095_nike_running_shoe.jpg','created_by' => '1','created_at' => '2018-01-03 23:13:02','updated_at' => '2018-06-11 07:41:35'),
  array('id' => '11','name' => 'U.S. Polo Men\'s Leather Belt','business_id' => '1','type' => 'single','unit_id' => '1','brand_id' => '3','category_id' => '3','sub_category_id' => '6','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '15','sku' => 'AS0011','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528727768_belt.jpg','created_by' => '1','created_at' => '2018-01-03 23:14:35','updated_at' => '2018-06-11 07:36:08'),
  array('id' => '12','name' => 'Unisex Brown Leather Wallet','business_id' => '1','type' => 'single','unit_id' => '1','brand_id' => '1','category_id' => '3','sub_category_id' => '11','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '10','sku' => 'AS0012','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528727750_unisex_brown_wallet.jpg','created_by' => '1','created_at' => '2018-01-03 23:15:50','updated_at' => '2018-06-11 07:35:50'),
  array('id' => '13','name' => 'Men Full sleeve T Shirt','business_id' => '1','type' => 'variable','unit_id' => '1','brand_id' => '2','category_id' => '1','sub_category_id' => '5','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '15','sku' => 'AS0013','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528728019_mens_tshirt.jpg','created_by' => '1','created_at' => '2018-01-03 23:17:59','updated_at' => '2018-06-11 07:40:19'),
  array('id' => '14','name' => 'Samsung Galaxy S8','business_id' => '1','type' => 'variable','unit_id' => '1','brand_id' => '7','category_id' => '12','sub_category_id' => '13','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '100','sku' => 'AS0014','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528728193_s8.jpg','created_by' => '1','created_at' => '2018-01-06 05:42:19','updated_at' => '2018-06-11 07:43:13'),
  array('id' => '15','name' => 'Apple iPhone 8','business_id' => '1','type' => 'variable','unit_id' => '1','brand_id' => '8','category_id' => '12','sub_category_id' => '13','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '100','sku' => 'AS0015','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528727817_iphone8.jpg','created_by' => '1','created_at' => '2018-01-06 05:49:51','updated_at' => '2018-06-11 07:36:57'),
  array('id' => '16','name' => 'Samsung Galaxy J7 Pro','business_id' => '1','type' => 'variable','unit_id' => '1','brand_id' => '7','category_id' => '12','sub_category_id' => '13','tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '100','sku' => 'AS0016','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528728178_j7_pro.jpg','created_by' => '1','created_at' => '2018-01-06 05:54:48','updated_at' => '2018-06-11 07:42:58'),
  array('id' => '17','name' => 'Acer Aspire E 15','business_id' => '1','type' => 'variable','unit_id' => '1','brand_id' => '9','category_id' => '12','sub_category_id' => '14','tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '70','sku' => 'AS0017','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528727793_acerE15.jpg','created_by' => '1','created_at' => '2018-01-06 06:05:01','updated_at' => '2018-06-11 07:36:33'),
  array('id' => '18','name' => 'Apple MacBook Air','business_id' => '1','type' => 'variable','unit_id' => '1','brand_id' => '8','category_id' => '12','sub_category_id' => '14','tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '30','sku' => 'AS0018','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528727849_macbookair.jpg','created_by' => '1','created_at' => '2018-01-06 06:07:30','updated_at' => '2018-06-11 07:37:29'),
  array('id' => '19','name' => 'Cushion Crew Socks','business_id' => '1','type' => 'single','unit_id' => '1','brand_id' => '4','category_id' => '15','sub_category_id' => '16','tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '100','sku' => 'AS0019','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528727903_socks.jpg','created_by' => '1','created_at' => '2018-01-06 06:10:28','updated_at' => '2018-06-11 07:38:23'),
  array('id' => '20','name' => 'Sports Tights Pants','business_id' => '1','type' => 'variable','unit_id' => '1','brand_id' => '6','category_id' => '15','sub_category_id' => '16','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '60','sku' => 'AS0020','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528728250_sports_pant.jpg','created_by' => '1','created_at' => '2018-01-06 06:13:00','updated_at' => '2018-06-11 07:44:10'),
  array('id' => '21','name' => 'Pair Of Dumbbells','business_id' => '1','type' => 'single','unit_id' => '1','brand_id' => '10','category_id' => '15','sub_category_id' => '17','tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '45','sku' => 'AS0021','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528728133_pair_of_dumbell.jpg','created_by' => '1','created_at' => '2018-01-06 06:16:35','updated_at' => '2018-06-11 07:42:13'),
  array('id' => '22','name' => 'Diary of a Wimpy Kid','business_id' => '1','type' => 'single','unit_id' => '1','brand_id' => NULL,'category_id' => '18','sub_category_id' => '20','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '20','sku' => 'AS0022','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528727917_diary_of_whimp_kid.jpeg','created_by' => '1','created_at' => '2018-01-06 06:25:09','updated_at' => '2018-06-11 07:38:37'),
  array('id' => '23','name' => 'Sneezy the Snowman','business_id' => '1','type' => 'single','unit_id' => '1','brand_id' => NULL,'category_id' => '18','sub_category_id' => '20','tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '20','sku' => 'AS0023','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528728231_sneezy.jpg','created_by' => '1','created_at' => '2018-01-06 06:26:27','updated_at' => '2018-06-11 07:43:51'),
  array('id' => '24','name' => 'Etched in Sand Autobiography','business_id' => '1','type' => 'single','unit_id' => '1','brand_id' => NULL,'category_id' => '18','sub_category_id' => '19','tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '30','sku' => 'AS0024','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528727933_etched_in_stone.jpg','created_by' => '1','created_at' => '2018-01-06 06:31:22','updated_at' => '2018-06-11 07:38:53'),
  array('id' => '25','name' => 'Five Presidents','business_id' => '1','type' => 'single','unit_id' => '1','brand_id' => NULL,'category_id' => '18','sub_category_id' => '19','tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '30','sku' => 'AS0025','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528727949_five_pesident.jpg','created_by' => '1','created_at' => '2018-01-06 06:32:22','updated_at' => '2018-06-11 07:39:09'),
  array('id' => '26','name' => 'Oreo Cookies','business_id' => '1','type' => 'single','unit_id' => '2','brand_id' => '11','category_id' => '21','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '500','sku' => 'AS0026','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528728111_oreo.jpg','created_by' => '1','created_at' => '2018-01-06 06:35:51','updated_at' => '2018-06-11 07:41:51'),
  array('id' => '27','name' => 'Butter Cookies','business_id' => '1','type' => 'single','unit_id' => '2','brand_id' => '12','category_id' => '21','sub_category_id' => NULL,'tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '100','sku' => 'AS0027','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528727881_butter_cookies.jpg','created_by' => '1','created_at' => '2018-01-06 06:43:16','updated_at' => '2018-06-11 07:38:01'),
  array('id' => '28','name' => 'Barilla Pasta','business_id' => '1','type' => 'single','unit_id' => '2','brand_id' => '13','category_id' => '21','sub_category_id' => NULL,'tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '50','sku' => 'AS0028','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528727865_barilla_pasta.jpeg','created_by' => '1','created_at' => '2018-01-06 06:45:47','updated_at' => '2018-06-11 07:37:45'),
  array('id' => '29','name' => 'Thin Spaghetti','business_id' => '1','type' => 'single','unit_id' => '2','brand_id' => '13','category_id' => '21','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '100','sku' => 'AS0029','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528728274_thin_spegatti.jpg','created_by' => '1','created_at' => '2018-01-06 06:46:53','updated_at' => '2018-06-11 07:44:34'),
  array('id' => '30','name' => 'Lipton Black Tea Bags','business_id' => '1','type' => 'single','unit_id' => '2','brand_id' => '14','category_id' => '21','sub_category_id' => NULL,'tax' => '1','tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '50','sku' => 'AS0030','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528727999_lipton_tea.jpg','created_by' => '1','created_at' => '2018-01-06 06:48:59','updated_at' => '2018-06-11 07:39:59'),
  array('id' => '31','name' => 'Dolocare 1g paracetol','business_id' => '2','type' => 'single','unit_id' => '4','brand_id' => '16','category_id' => '27','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '50','sku' => 'AP0031','barcode_type' => 'C128','expiry_period' => '24.00','expiry_period_type' => 'months','enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '4','created_at' => '2018-04-10 10:06:29','updated_at' => '2018-04-10 10:06:29'),
  array('id' => '32','name' => 'Lexin 500mg capsule','business_id' => '2','type' => 'single','unit_id' => '4','brand_id' => '16','category_id' => '22','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '30','sku' => 'AP0032','barcode_type' => 'C128','expiry_period' => '24.00','expiry_period_type' => 'months','enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '4','created_at' => '2018-04-10 10:07:52','updated_at' => '2018-04-10 10:07:52'),
  array('id' => '33','name' => 'Oflen-75','business_id' => '2','type' => 'single','unit_id' => '4','brand_id' => '15','category_id' => '22','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '30','sku' => 'AP0033','barcode_type' => 'C128','expiry_period' => '36.00','expiry_period_type' => 'months','enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '4','created_at' => '2018-04-10 10:09:45','updated_at' => '2018-04-10 10:09:45'),
  array('id' => '34','name' => 'Cistiben Forte','business_id' => '2','type' => 'single','unit_id' => '4','brand_id' => '16','category_id' => '22','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '25','sku' => 'AP0034','barcode_type' => 'C128','expiry_period' => '12.00','expiry_period_type' => 'months','enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '4','created_at' => '2018-04-10 10:10:59','updated_at' => '2018-04-10 10:10:59'),
  array('id' => '35','name' => 'Disflatyl drop 30ml','business_id' => '2','type' => 'single','unit_id' => '4','brand_id' => '17','category_id' => '25','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '20','sku' => 'AP0035','barcode_type' => 'C128','expiry_period' => '12.00','expiry_period_type' => 'months','enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '4','created_at' => '2018-04-10 10:12:53','updated_at' => '2018-04-10 10:12:53'),
  array('id' => '36','name' => 'Mycoheal 40','business_id' => '2','type' => 'single','unit_id' => '4','brand_id' => '17','category_id' => '26','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '30','sku' => 'AP0036','barcode_type' => 'C128','expiry_period' => '6.00','expiry_period_type' => 'months','enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '4','created_at' => '2018-04-10 10:14:18','updated_at' => '2018-04-10 10:14:18'),
  array('id' => '37','name' => 'Laboxyl','business_id' => '2','type' => 'single','unit_id' => '4','brand_id' => '16','category_id' => '24','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '20','sku' => 'AP0037','barcode_type' => 'C128','expiry_period' => '12.00','expiry_period_type' => 'months','enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '4','created_at' => '2018-04-10 10:31:29','updated_at' => '2018-04-10 10:31:29'),
  array('id' => '38','name' => 'Fertilex plus men','business_id' => '2','type' => 'single','unit_id' => '4','brand_id' => '15','category_id' => '22','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '30','sku' => 'AP0038','barcode_type' => 'C128','expiry_period' => '12.00','expiry_period_type' => 'months','enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '4','created_at' => '2018-04-10 10:32:35','updated_at' => '2018-04-10 10:32:35'),
  array('id' => '39','name' => 'vitamin E AIWA','business_id' => '2','type' => 'single','unit_id' => '4','brand_id' => '15','category_id' => '22','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '20','sku' => 'AP0039','barcode_type' => 'C128','expiry_period' => '12.00','expiry_period_type' => 'months','enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '4','created_at' => '2018-04-10 10:33:26','updated_at' => '2018-04-10 10:33:26'),
  array('id' => '40','name' => 'Glycerol 4g','business_id' => '2','type' => 'single','unit_id' => '4','brand_id' => '16','category_id' => '22','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '20','sku' => 'AP0040','barcode_type' => 'C128','expiry_period' => '12.00','expiry_period_type' => 'months','enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '4','created_at' => '2018-04-10 10:34:32','updated_at' => '2018-04-10 10:34:49'),
  array('id' => '41','name' => 'HP 15-AY020TU','business_id' => '3','type' => 'single','unit_id' => '5','brand_id' => '23','category_id' => '30','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'inclusive','enable_stock' => '1','alert_quantity' => '10','sku' => 'AE0041','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '1','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '5','created_at' => '2018-04-10 11:08:27','updated_at' => '2018-04-10 11:08:27'),
  array('id' => '42','name' => 'HP Pavilion 15-AU624TX','business_id' => '3','type' => 'single','unit_id' => '5','brand_id' => '23','category_id' => NULL,'sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '10','sku' => 'AE0042','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '1','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '5','created_at' => '2018-04-10 11:15:52','updated_at' => '2018-04-10 11:51:21'),
  array('id' => '43','name' => 'iPhone 6s plus','business_id' => '3','type' => 'single','unit_id' => '5','brand_id' => '20','category_id' => '28','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '20','sku' => 'AE0043','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '1','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '5','created_at' => '2018-04-10 11:18:01','updated_at' => '2018-04-10 11:18:01'),
  array('id' => '44','name' => 'Samsung J7 Pro','business_id' => '3','type' => 'single','unit_id' => '5','brand_id' => '18','category_id' => '28','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '20','sku' => 'AE0044','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '5','created_at' => '2018-04-10 11:19:10','updated_at' => '2018-04-10 11:19:10'),
  array('id' => '45','name' => 'Samsung Galaxy S7 Edge','business_id' => '3','type' => 'single','unit_id' => '5','brand_id' => '18','category_id' => '28','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '20','sku' => 'AE0045','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '1','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '5','created_at' => '2018-04-10 11:20:21','updated_at' => '2018-04-10 11:20:21'),
  array('id' => '46','name' => 'LG G6 64 GB','business_id' => '3','type' => 'single','unit_id' => '5','brand_id' => '19','category_id' => '28','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '10','sku' => 'AE0046','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '1','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '5','created_at' => '2018-04-10 11:22:04','updated_at' => '2018-04-10 11:22:04'),
  array('id' => '47','name' => 'Panasonic TH-58D300DX','business_id' => '3','type' => 'single','unit_id' => '5','brand_id' => '22','category_id' => '31','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '20','sku' => 'AE0047','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '1','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '5','created_at' => '2018-04-10 11:23:45','updated_at' => '2018-04-10 11:23:45'),
  array('id' => '48','name' => 'Samsung 50MU6100','business_id' => '3','type' => 'single','unit_id' => '5','brand_id' => '18','category_id' => NULL,'sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '7','sku' => 'AE0048','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '1','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '5','created_at' => '2018-04-10 11:24:42','updated_at' => '2018-04-10 11:52:07'),
  array('id' => '49','name' => 'LG 55E7T','business_id' => '3','type' => 'single','unit_id' => '5','brand_id' => '19','category_id' => '31','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '5','sku' => 'AE0049','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '1','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '5','created_at' => '2018-04-10 11:25:55','updated_at' => '2018-04-10 11:25:55'),
  array('id' => '50','name' => 'SONY ILCE-6000L/B','business_id' => '3','type' => 'single','unit_id' => '5','brand_id' => '21','category_id' => NULL,'sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '10','sku' => 'AE0050','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '1','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '5','created_at' => '2018-04-10 11:34:32','updated_at' => '2018-04-10 11:34:32'),
  array('id' => '51','name' => 'Oil and filter change','business_id' => '4','type' => 'single','unit_id' => '6','brand_id' => NULL,'category_id' => '34','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AS0051','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '6','created_at' => '2018-04-10 12:34:57','updated_at' => '2018-04-10 12:34:57'),
  array('id' => '52','name' => 'Removal of wheels and brakes checked','business_id' => '4','type' => 'single','unit_id' => '6','brand_id' => NULL,'category_id' => '34','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AS0052','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '6','created_at' => '2018-04-10 12:35:55','updated_at' => '2018-04-10 12:35:55'),
  array('id' => '53','name' => 'Full body wash','business_id' => '4','type' => 'single','unit_id' => '6','brand_id' => NULL,'category_id' => '34','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AS0053','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '6','created_at' => '2018-04-10 12:39:15','updated_at' => '2018-04-10 12:39:15'),
  array('id' => '54','name' => 'Hair Cut','business_id' => '4','type' => 'single','unit_id' => '6','brand_id' => NULL,'category_id' => '35','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AS0054','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '6','created_at' => '2018-04-10 12:54:16','updated_at' => '2018-04-10 12:54:16'),
  array('id' => '55','name' => 'Wash And Blow Dry','business_id' => '4','type' => 'single','unit_id' => '6','brand_id' => NULL,'category_id' => '35','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AS0055','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '6','created_at' => '2018-04-10 12:56:18','updated_at' => '2018-04-10 12:56:18'),
  array('id' => '56','name' => 'Thai massage','business_id' => '4','type' => 'single','unit_id' => '6','brand_id' => NULL,'category_id' => '38','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AS0056','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '6','created_at' => '2018-04-10 13:01:59','updated_at' => '2018-04-10 13:01:59'),
  array('id' => '57','name' => 'Toilet Repair','business_id' => '4','type' => 'single','unit_id' => '6','brand_id' => NULL,'category_id' => '36','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AS0057','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '6','created_at' => '2018-04-10 13:03:01','updated_at' => '2018-04-10 13:03:01'),
  array('id' => '58','name' => 'Sewer Repair','business_id' => '4','type' => 'single','unit_id' => '6','brand_id' => NULL,'category_id' => '36','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AS0058','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '6','created_at' => '2018-04-10 13:03:37','updated_at' => '2018-04-10 13:03:37'),
  array('id' => '59','name' => 'Refrigerator Repair','business_id' => '4','type' => 'single','unit_id' => '6','brand_id' => NULL,'category_id' => NULL,'sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AS0059','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '6','created_at' => '2018-04-10 13:06:45','updated_at' => '2018-04-10 13:06:45'),
  array('id' => '60','name' => 'AC Repair','business_id' => '4','type' => 'single','unit_id' => '6','brand_id' => NULL,'category_id' => NULL,'sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AS0060','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '6','created_at' => '2018-04-10 13:07:08','updated_at' => '2018-04-10 13:07:08'),
  array('id' => '61','name' => 'Red Wine','business_id' => '1','type' => 'single','unit_id' => '1','brand_id' => NULL,'category_id' => '21','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '10','sku' => 'AS0061','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528779460_wine.jpg','created_by' => '1','created_at' => '2018-06-11 21:57:41','updated_at' => '2018-06-11 21:57:41'),
  array('id' => '62','name' => 'Pinot Noir Red Wine','business_id' => '1','type' => 'single','unit_id' => '1','brand_id' => NULL,'category_id' => NULL,'sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '10','sku' => 'AS0062','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528779737_wine2.jpg','created_by' => '1','created_at' => '2018-06-11 22:02:17','updated_at' => '2018-06-11 22:02:17'),
  array('id' => '63','name' => 'Banana','business_id' => '1','type' => 'single','unit_id' => '1','brand_id' => NULL,'category_id' => NULL,'sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '100','sku' => 'AS0063','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528780092_banana.jpg','created_by' => '1','created_at' => '2018-06-11 22:08:12','updated_at' => '2018-06-11 22:08:12'),
  array('id' => '64','name' => 'Apple - Fuji','business_id' => '1','type' => 'single','unit_id' => '1','brand_id' => NULL,'category_id' => '21','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '50','sku' => 'AS0064','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528780234_apples.jpg','created_by' => '1','created_at' => '2018-06-11 22:10:34','updated_at' => '2018-06-11 22:10:34'),
  array('id' => '65','name' => 'Organic Egg','business_id' => '1','type' => 'single','unit_id' => '1','brand_id' => NULL,'category_id' => '21','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '10','sku' => 'AS0065','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1528780470_eggs.jpg','created_by' => '1','created_at' => '2018-06-11 22:14:00','updated_at' => '2018-06-11 22:14:30'),
  array('id' => '66','name' => 'Honey Roast Chicken','business_id' => '5','type' => 'single','unit_id' => '7','brand_id' => NULL,'category_id' => '39','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AR0066','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => '300 gm','product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1531481431_honey-roast-chicken.jpg','created_by' => '7','created_at' => '2018-07-13 06:30:31','updated_at' => '2018-07-13 06:30:31'),
  array('id' => '67','name' => 'Mushroom and Herb Filled Tomatoes','business_id' => '5','type' => 'single','unit_id' => '7','brand_id' => NULL,'category_id' => '39','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AR0067','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => '150 gm','product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1531481687_tomtoes-with-mushroom_med.jpg','created_by' => '7','created_at' => '2018-07-13 06:34:47','updated_at' => '2018-07-13 06:34:47'),
  array('id' => '68','name' => 'Pasta Carbonara','business_id' => '5','type' => 'single','unit_id' => '7','brand_id' => NULL,'category_id' => '40','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AR0068','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => '180 gm','product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1531481935_pasta.jpg','created_by' => '7','created_at' => '2018-07-13 06:38:55','updated_at' => '2018-07-13 06:38:55'),
  array('id' => '69','name' => 'Chicken Doner Pita with Hummus','business_id' => '5','type' => 'single','unit_id' => '7','brand_id' => NULL,'category_id' => '40','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AR0069','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => '180 gm','product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1531482350_pita.jpg','created_by' => '7','created_at' => '2018-07-13 06:45:50','updated_at' => '2018-07-13 06:45:51'),
  array('id' => '70','name' => 'Falafal Doner Salad','business_id' => '5','type' => 'single','unit_id' => '7','brand_id' => NULL,'category_id' => '41','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AR0070','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => '200 gm','product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1531483057_salad-doner.jpg','created_by' => '7','created_at' => '2018-07-13 06:57:37','updated_at' => '2018-07-13 06:57:37'),
  array('id' => '71','name' => 'Lamb Doner Salad','business_id' => '5','type' => 'single','unit_id' => '7','brand_id' => NULL,'category_id' => '41','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AR0071','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => '220 gm','product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1531483241_lamb-salad.jpg','created_by' => '7','created_at' => '2018-07-13 07:00:41','updated_at' => '2018-07-13 07:00:41'),
  array('id' => '72','name' => 'Chicago-Style Pan Pizza','business_id' => '5','type' => 'single','unit_id' => '7','brand_id' => NULL,'category_id' => '42','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AR0072','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => '190 gm','product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1531483502_pizza1.jpg','created_by' => '7','created_at' => '2018-07-13 07:05:02','updated_at' => '2018-07-13 07:05:03'),
  array('id' => '73','name' => 'Pizza Margherita','business_id' => '5','type' => 'single','unit_id' => '7','brand_id' => NULL,'category_id' => '42','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AR0073','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => '200 gm','product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1531483649_margherita-pizza.jpg','created_by' => '7','created_at' => '2018-07-13 07:07:29','updated_at' => '2018-07-13 07:07:29'),
  array('id' => '74','name' => 'Blueberry-Ginger Mojito','business_id' => '5','type' => 'single','unit_id' => '7','brand_id' => NULL,'category_id' => '44','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AR0074','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1531483843_mojito.jpg','created_by' => '7','created_at' => '2018-07-13 07:10:43','updated_at' => '2018-07-13 07:10:44'),
  array('id' => '75','name' => 'Chocolate Brownie','business_id' => '5','type' => 'single','unit_id' => '7','brand_id' => NULL,'category_id' => '43','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AR0075','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1531483989_Chocolate-Brownies.jpg','created_by' => '7','created_at' => '2018-07-13 07:13:09','updated_at' => '2018-07-13 07:13:09'),
  array('id' => '76','name' => 'Pepsi Soft Drink','business_id' => '5','type' => 'single','unit_id' => '7','brand_id' => NULL,'category_id' => '44','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '50','sku' => 'AR0076','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1531484313_pepsi.jpg','created_by' => '7','created_at' => '2018-07-13 07:18:33','updated_at' => '2018-07-13 07:18:33'),
  array('id' => '77','name' => 'Brown Bread','business_id' => '5','type' => 'single','unit_id' => '8','brand_id' => NULL,'category_id' => '45','sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'exclusive','enable_stock' => '1','alert_quantity' => '50','sku' => 'AR0077','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => '1531484661_brown-bread.jpg','created_by' => '7','created_at' => '2018-07-13 07:24:21','updated_at' => '2018-07-13 07:28:56'),
  array('id' => '78','name' => 'Toppings','business_id' => '5','type' => 'modifier','unit_id' => NULL,'brand_id' => NULL,'category_id' => NULL,'sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'inclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AR0078','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '7','created_at' => '2018-07-16 07:58:04','updated_at' => '2018-07-16 07:58:04'),
  array('id' => '79','name' => 'Extra','business_id' => '5','type' => 'modifier','unit_id' => NULL,'brand_id' => NULL,'category_id' => NULL,'sub_category_id' => NULL,'tax' => NULL,'tax_type' => 'inclusive','enable_stock' => '0','alert_quantity' => '0','sku' => 'AR0079','barcode_type' => 'C128','expiry_period' => NULL,'expiry_period_type' => NULL,'enable_sr_no' => '0','weight' => NULL,'product_custom_field1' => NULL,'product_custom_field2' => NULL,'product_custom_field3' => NULL,'product_custom_field4' => NULL,'image' => NULL,'created_by' => '7','created_at' => '2018-07-16 08:05:37','updated_at' => '2018-07-16 08:05:37')
);
DB::table('products')->insert($products);

$product_variations = array(
  array('id' => '1','name' => 'DUMMY','product_id' => '1','is_dummy' => '1','created_at' => '2018-01-03 21:29:08','updated_at' => '2018-01-03 21:29:08'),
  array('id' => '2','name' => 'Waist Size','product_id' => '2','is_dummy' => '0','created_at' => '2018-01-03 21:30:35','updated_at' => '2018-01-06 05:14:12'),
  array('id' => '3','name' => 'Size','product_id' => '3','is_dummy' => '0','created_at' => '2018-01-03 22:51:52','updated_at' => '2018-01-06 05:13:48'),
  array('id' => '4','name' => 'Size','product_id' => '4','is_dummy' => '0','created_at' => '2018-01-03 22:54:34','updated_at' => '2018-01-06 05:19:36'),
  array('id' => '8','name' => 'Size','product_id' => '8','is_dummy' => '0','created_at' => '2018-01-03 23:10:10','updated_at' => '2018-01-06 05:18:46'),
  array('id' => '9','name' => 'Size','product_id' => '9','is_dummy' => '0','created_at' => '2018-01-03 23:11:57','updated_at' => '2018-01-06 05:20:01'),
  array('id' => '10','name' => 'Size','product_id' => '10','is_dummy' => '0','created_at' => '2018-01-03 23:13:02','updated_at' => '2018-01-06 05:19:20'),
  array('id' => '11','name' => 'DUMMY','product_id' => '11','is_dummy' => '1','created_at' => '2018-01-03 23:14:35','updated_at' => '2018-01-03 23:14:35'),
  array('id' => '12','name' => 'DUMMY','product_id' => '12','is_dummy' => '1','created_at' => '2018-01-03 23:15:50','updated_at' => '2018-01-03 23:15:50'),
  array('id' => '13','name' => 'Size','product_id' => '13','is_dummy' => '0','created_at' => '2018-01-03 23:17:59','updated_at' => '2018-01-06 05:14:48'),
  array('id' => '14','name' => 'Color','product_id' => '14','is_dummy' => '0','created_at' => '2018-01-06 05:42:19','updated_at' => '2018-01-06 05:42:19'),
  array('id' => '15','name' => 'Internal Memory','product_id' => '14','is_dummy' => '0','created_at' => '2018-01-06 05:44:14','updated_at' => '2018-01-06 05:44:14'),
  array('id' => '16','name' => 'Color','product_id' => '15','is_dummy' => '0','created_at' => '2018-01-06 05:49:51','updated_at' => '2018-01-06 05:49:51'),
  array('id' => '17','name' => 'Internal Memory','product_id' => '15','is_dummy' => '0','created_at' => '2018-01-06 05:49:51','updated_at' => '2018-01-06 05:49:51'),
  array('id' => '18','name' => 'Color','product_id' => '16','is_dummy' => '0','created_at' => '2018-01-06 05:54:48','updated_at' => '2018-01-06 05:54:48'),
  array('id' => '19','name' => 'Color','product_id' => '17','is_dummy' => '0','created_at' => '2018-01-06 06:05:01','updated_at' => '2018-01-06 06:05:01'),
  array('id' => '20','name' => 'Storage','product_id' => '18','is_dummy' => '0','created_at' => '2018-01-06 06:07:30','updated_at' => '2018-01-06 06:07:30'),
  array('id' => '21','name' => 'DUMMY','product_id' => '19','is_dummy' => '1','created_at' => '2018-01-06 06:10:28','updated_at' => '2018-01-06 06:10:28'),
  array('id' => '22','name' => 'Color','product_id' => '20','is_dummy' => '0','created_at' => '2018-01-06 06:13:00','updated_at' => '2018-01-06 06:13:00'),
  array('id' => '23','name' => 'DUMMY','product_id' => '21','is_dummy' => '1','created_at' => '2018-01-06 06:16:35','updated_at' => '2018-01-06 06:16:35'),
  array('id' => '24','name' => 'DUMMY','product_id' => '22','is_dummy' => '1','created_at' => '2018-01-06 06:25:09','updated_at' => '2018-01-06 06:25:09'),
  array('id' => '25','name' => 'DUMMY','product_id' => '23','is_dummy' => '1','created_at' => '2018-01-06 06:26:27','updated_at' => '2018-01-06 06:26:27'),
  array('id' => '26','name' => 'DUMMY','product_id' => '24','is_dummy' => '1','created_at' => '2018-01-06 06:31:22','updated_at' => '2018-01-06 06:31:22'),
  array('id' => '27','name' => 'DUMMY','product_id' => '25','is_dummy' => '1','created_at' => '2018-01-06 06:32:23','updated_at' => '2018-01-06 06:32:23'),
  array('id' => '28','name' => 'DUMMY','product_id' => '26','is_dummy' => '1','created_at' => '2018-01-06 06:35:51','updated_at' => '2018-01-06 06:35:51'),
  array('id' => '29','name' => 'DUMMY','product_id' => '27','is_dummy' => '1','created_at' => '2018-01-06 06:43:16','updated_at' => '2018-01-06 06:43:16'),
  array('id' => '30','name' => 'DUMMY','product_id' => '28','is_dummy' => '1','created_at' => '2018-01-06 06:45:47','updated_at' => '2018-01-06 06:45:47'),
  array('id' => '31','name' => 'DUMMY','product_id' => '29','is_dummy' => '1','created_at' => '2018-01-06 06:46:53','updated_at' => '2018-01-06 06:46:53'),
  array('id' => '32','name' => 'DUMMY','product_id' => '30','is_dummy' => '1','created_at' => '2018-01-06 06:48:59','updated_at' => '2018-01-06 06:48:59'),
  array('id' => '33','name' => 'DUMMY','product_id' => '31','is_dummy' => '1','created_at' => '2018-04-10 10:06:29','updated_at' => '2018-04-10 10:06:29'),
  array('id' => '34','name' => 'DUMMY','product_id' => '32','is_dummy' => '1','created_at' => '2018-04-10 10:07:52','updated_at' => '2018-04-10 10:07:52'),
  array('id' => '35','name' => 'DUMMY','product_id' => '33','is_dummy' => '1','created_at' => '2018-04-10 10:09:45','updated_at' => '2018-04-10 10:09:45'),
  array('id' => '36','name' => 'DUMMY','product_id' => '34','is_dummy' => '1','created_at' => '2018-04-10 10:10:59','updated_at' => '2018-04-10 10:10:59'),
  array('id' => '37','name' => 'DUMMY','product_id' => '35','is_dummy' => '1','created_at' => '2018-04-10 10:12:53','updated_at' => '2018-04-10 10:12:53'),
  array('id' => '38','name' => 'DUMMY','product_id' => '36','is_dummy' => '1','created_at' => '2018-04-10 10:14:18','updated_at' => '2018-04-10 10:14:18'),
  array('id' => '39','name' => 'DUMMY','product_id' => '37','is_dummy' => '1','created_at' => '2018-04-10 10:31:29','updated_at' => '2018-04-10 10:31:29'),
  array('id' => '40','name' => 'DUMMY','product_id' => '38','is_dummy' => '1','created_at' => '2018-04-10 10:32:35','updated_at' => '2018-04-10 10:32:35'),
  array('id' => '41','name' => 'DUMMY','product_id' => '39','is_dummy' => '1','created_at' => '2018-04-10 10:33:26','updated_at' => '2018-04-10 10:33:26'),
  array('id' => '42','name' => 'DUMMY','product_id' => '40','is_dummy' => '1','created_at' => '2018-04-10 10:34:32','updated_at' => '2018-04-10 10:34:32'),
  array('id' => '43','name' => 'DUMMY','product_id' => '41','is_dummy' => '1','created_at' => '2018-04-10 11:08:27','updated_at' => '2018-04-10 11:08:27'),
  array('id' => '44','name' => 'DUMMY','product_id' => '42','is_dummy' => '1','created_at' => '2018-04-10 11:15:52','updated_at' => '2018-04-10 11:15:52'),
  array('id' => '45','name' => 'DUMMY','product_id' => '43','is_dummy' => '1','created_at' => '2018-04-10 11:18:01','updated_at' => '2018-04-10 11:18:01'),
  array('id' => '46','name' => 'DUMMY','product_id' => '44','is_dummy' => '1','created_at' => '2018-04-10 11:19:10','updated_at' => '2018-04-10 11:19:10'),
  array('id' => '47','name' => 'DUMMY','product_id' => '45','is_dummy' => '1','created_at' => '2018-04-10 11:20:22','updated_at' => '2018-04-10 11:20:22'),
  array('id' => '48','name' => 'DUMMY','product_id' => '46','is_dummy' => '1','created_at' => '2018-04-10 11:22:04','updated_at' => '2018-04-10 11:22:04'),
  array('id' => '49','name' => 'DUMMY','product_id' => '47','is_dummy' => '1','created_at' => '2018-04-10 11:23:45','updated_at' => '2018-04-10 11:23:45'),
  array('id' => '50','name' => 'DUMMY','product_id' => '48','is_dummy' => '1','created_at' => '2018-04-10 11:24:42','updated_at' => '2018-04-10 11:24:42'),
  array('id' => '51','name' => 'DUMMY','product_id' => '49','is_dummy' => '1','created_at' => '2018-04-10 11:25:55','updated_at' => '2018-04-10 11:25:55'),
  array('id' => '52','name' => 'DUMMY','product_id' => '50','is_dummy' => '1','created_at' => '2018-04-10 11:34:32','updated_at' => '2018-04-10 11:34:32'),
  array('id' => '53','name' => 'DUMMY','product_id' => '51','is_dummy' => '1','created_at' => '2018-04-10 12:34:57','updated_at' => '2018-04-10 12:34:57'),
  array('id' => '54','name' => 'DUMMY','product_id' => '52','is_dummy' => '1','created_at' => '2018-04-10 12:35:55','updated_at' => '2018-04-10 12:35:55'),
  array('id' => '55','name' => 'DUMMY','product_id' => '53','is_dummy' => '1','created_at' => '2018-04-10 12:39:15','updated_at' => '2018-04-10 12:39:15'),
  array('id' => '56','name' => 'DUMMY','product_id' => '54','is_dummy' => '1','created_at' => '2018-04-10 12:54:16','updated_at' => '2018-04-10 12:54:16'),
  array('id' => '57','name' => 'DUMMY','product_id' => '55','is_dummy' => '1','created_at' => '2018-04-10 12:56:18','updated_at' => '2018-04-10 12:56:18'),
  array('id' => '58','name' => 'DUMMY','product_id' => '56','is_dummy' => '1','created_at' => '2018-04-10 13:01:59','updated_at' => '2018-04-10 13:01:59'),
  array('id' => '59','name' => 'DUMMY','product_id' => '57','is_dummy' => '1','created_at' => '2018-04-10 13:03:01','updated_at' => '2018-04-10 13:03:01'),
  array('id' => '60','name' => 'DUMMY','product_id' => '58','is_dummy' => '1','created_at' => '2018-04-10 13:03:37','updated_at' => '2018-04-10 13:03:37'),
  array('id' => '61','name' => 'DUMMY','product_id' => '59','is_dummy' => '1','created_at' => '2018-04-10 13:06:45','updated_at' => '2018-04-10 13:06:45'),
  array('id' => '62','name' => 'DUMMY','product_id' => '60','is_dummy' => '1','created_at' => '2018-04-10 13:07:08','updated_at' => '2018-04-10 13:07:08'),
  array('id' => '63','name' => 'DUMMY','product_id' => '61','is_dummy' => '1','created_at' => '2018-04-10 13:07:08','updated_at' => '2018-04-10 13:07:08'),
  array('id' => '64','name' => 'DUMMY','product_id' => '62','is_dummy' => '1','created_at' => '2018-04-10 13:07:08','updated_at' => '2018-04-10 13:07:08'),
  array('id' => '65','name' => 'DUMMY','product_id' => '63','is_dummy' => '1','created_at' => '2018-04-10 13:07:08','updated_at' => '2018-04-10 13:07:08'),
  array('id' => '66','name' => 'DUMMY','product_id' => '64','is_dummy' => '1','created_at' => '2018-04-10 13:07:08','updated_at' => '2018-04-10 13:07:08'),
  array('id' => '67','name' => 'DUMMY','product_id' => '65','is_dummy' => '1','created_at' => '2018-04-10 13:07:08','updated_at' => '2018-04-10 13:07:08'),
  array('id' => '68','name' => 'DUMMY','product_id' => '66','is_dummy' => '1','created_at' => '2018-07-13 01:00:31','updated_at' => '2018-07-13 01:00:31'),
  array('id' => '69','name' => 'DUMMY','product_id' => '67','is_dummy' => '1','created_at' => '2018-07-13 01:04:47','updated_at' => '2018-07-13 01:04:47'),
  array('id' => '70','name' => 'DUMMY','product_id' => '68','is_dummy' => '1','created_at' => '2018-07-13 01:08:55','updated_at' => '2018-07-13 01:08:55'),
  array('id' => '71','name' => 'DUMMY','product_id' => '69','is_dummy' => '1','created_at' => '2018-07-13 01:15:51','updated_at' => '2018-07-13 01:15:51'),
  array('id' => '72','name' => 'DUMMY','product_id' => '70','is_dummy' => '1','created_at' => '2018-07-13 01:27:37','updated_at' => '2018-07-13 01:27:37'),
  array('id' => '73','name' => 'DUMMY','product_id' => '71','is_dummy' => '1','created_at' => '2018-07-13 01:30:41','updated_at' => '2018-07-13 01:30:41'),
  array('id' => '74','name' => 'DUMMY','product_id' => '72','is_dummy' => '1','created_at' => '2018-07-13 01:35:03','updated_at' => '2018-07-13 01:35:03'),
  array('id' => '75','name' => 'DUMMY','product_id' => '73','is_dummy' => '1','created_at' => '2018-07-13 01:37:29','updated_at' => '2018-07-13 01:37:29'),
  array('id' => '76','name' => 'DUMMY','product_id' => '74','is_dummy' => '1','created_at' => '2018-07-13 01:40:44','updated_at' => '2018-07-13 01:40:44'),
  array('id' => '77','name' => 'DUMMY','product_id' => '75','is_dummy' => '1','created_at' => '2018-07-13 01:43:09','updated_at' => '2018-07-13 01:43:09'),
  array('id' => '78','name' => 'DUMMY','product_id' => '76','is_dummy' => '1','created_at' => '2018-07-13 01:48:33','updated_at' => '2018-07-13 01:48:33'),
  array('id' => '79','name' => 'DUMMY','product_id' => '77','is_dummy' => '1','created_at' => '2018-07-13 01:54:22','updated_at' => '2018-07-13 01:54:22'),
  array('id' => '80','name' => 'DUMMY','product_id' => '78','is_dummy' => '0','created_at' => '2018-07-16 07:58:04','updated_at' => '2018-07-16 07:58:04'),
  array('id' => '81','name' => 'DUMMY','product_id' => '79','is_dummy' => '0','created_at' => '2018-07-16 08:05:37','updated_at' => '2018-07-16 08:05:37')
);
DB::table('product_variations')->insert($product_variations);

$variations = array(
  array('id' => '1','name' => 'DUMMY','product_id' => '1','sub_sku' => 'AS0001','product_variation_id' => '1','default_purchase_price' => '130.00','dpp_inc_tax' => '143.00','profit_percent' => '0.00','default_sell_price' => '130.00','sell_price_inc_tax' => '143.00','created_at' => '2018-01-03 21:29:08','updated_at' => '2018-06-11 07:40:59','deleted_at' => NULL),
  array('id' => '2','name' => '28','product_id' => '2','sub_sku' => 'AS0002-1','product_variation_id' => '2','default_purchase_price' => '70.00','dpp_inc_tax' => '77.00','profit_percent' => '0.00','default_sell_price' => '70.00','sell_price_inc_tax' => '77.00','created_at' => '2018-01-03 21:30:35','updated_at' => '2018-06-11 07:39:24','deleted_at' => NULL),
  array('id' => '3','name' => '30','product_id' => '2','sub_sku' => 'AS0002-2','product_variation_id' => '2','default_purchase_price' => '70.00','dpp_inc_tax' => '77.00','profit_percent' => '0.00','default_sell_price' => '70.00','sell_price_inc_tax' => '77.00','created_at' => '2018-01-03 21:30:35','updated_at' => '2018-06-11 07:39:24','deleted_at' => NULL),
  array('id' => '4','name' => '32','product_id' => '2','sub_sku' => 'AS0002-3','product_variation_id' => '2','default_purchase_price' => '70.00','dpp_inc_tax' => '77.00','profit_percent' => '0.00','default_sell_price' => '70.00','sell_price_inc_tax' => '77.00','created_at' => '2018-01-03 21:30:35','updated_at' => '2018-06-11 07:39:24','deleted_at' => NULL),
  array('id' => '5','name' => '34','product_id' => '2','sub_sku' => 'AS0002-4','product_variation_id' => '2','default_purchase_price' => '72.00','dpp_inc_tax' => '79.20','profit_percent' => '0.00','default_sell_price' => '72.00','sell_price_inc_tax' => '79.20','created_at' => '2018-01-03 21:30:35','updated_at' => '2018-06-11 07:39:24','deleted_at' => NULL),
  array('id' => '6','name' => '36','product_id' => '2','sub_sku' => 'AS0002-5','product_variation_id' => '2','default_purchase_price' => '72.00','dpp_inc_tax' => '79.20','profit_percent' => '0.00','default_sell_price' => '72.00','sell_price_inc_tax' => '79.20','created_at' => '2018-01-03 21:30:35','updated_at' => '2018-06-11 07:39:24','deleted_at' => NULL),
  array('id' => '7','name' => 'S','product_id' => '3','sub_sku' => 'AS0003-1','product_variation_id' => '3','default_purchase_price' => '190.00','dpp_inc_tax' => '209.00','profit_percent' => '0.00','default_sell_price' => '190.00','sell_price_inc_tax' => '209.00','created_at' => '2018-01-03 22:51:52','updated_at' => '2018-06-11 07:40:35','deleted_at' => NULL),
  array('id' => '8','name' => 'M','product_id' => '3','sub_sku' => 'AS0003-2','product_variation_id' => '3','default_purchase_price' => '190.00','dpp_inc_tax' => '209.00','profit_percent' => '0.00','default_sell_price' => '190.00','sell_price_inc_tax' => '209.00','created_at' => '2018-01-03 22:51:52','updated_at' => '2018-06-11 07:40:35','deleted_at' => NULL),
  array('id' => '9','name' => 'L','product_id' => '3','sub_sku' => 'AS0003-3','product_variation_id' => '3','default_purchase_price' => '190.00','dpp_inc_tax' => '209.00','profit_percent' => '0.00','default_sell_price' => '190.00','sell_price_inc_tax' => '209.00','created_at' => '2018-01-03 22:51:52','updated_at' => '2018-06-11 07:40:35','deleted_at' => NULL),
  array('id' => '10','name' => 'XL','product_id' => '3','sub_sku' => 'AS0003-4','product_variation_id' => '3','default_purchase_price' => '191.00','dpp_inc_tax' => '210.10','profit_percent' => '0.00','default_sell_price' => '191.00','sell_price_inc_tax' => '210.10','created_at' => '2018-01-03 22:51:52','updated_at' => '2018-06-11 07:40:35','deleted_at' => NULL),
  array('id' => '11','name' => '6','product_id' => '4','sub_sku' => 'AS0004-1','product_variation_id' => '4','default_purchase_price' => '165.00','dpp_inc_tax' => '181.50','profit_percent' => '0.00','default_sell_price' => '165.00','sell_price_inc_tax' => '181.50','created_at' => '2018-01-03 22:54:34','updated_at' => '2018-06-11 07:42:27','deleted_at' => NULL),
  array('id' => '12','name' => '7','product_id' => '4','sub_sku' => 'AS0004-2','product_variation_id' => '4','default_purchase_price' => '165.00','dpp_inc_tax' => '181.50','profit_percent' => '0.00','default_sell_price' => '165.00','sell_price_inc_tax' => '181.50','created_at' => '2018-01-03 22:54:34','updated_at' => '2018-06-11 07:42:27','deleted_at' => NULL),
  array('id' => '13','name' => '8','product_id' => '4','sub_sku' => 'AS0004-3','product_variation_id' => '4','default_purchase_price' => '165.00','dpp_inc_tax' => '181.50','profit_percent' => '0.00','default_sell_price' => '165.00','sell_price_inc_tax' => '181.50','created_at' => '2018-01-03 22:54:34','updated_at' => '2018-06-11 07:42:27','deleted_at' => NULL),
  array('id' => '14','name' => '9','product_id' => '4','sub_sku' => 'AS0004-4','product_variation_id' => '4','default_purchase_price' => '166.00','dpp_inc_tax' => '182.60','profit_percent' => '0.00','default_sell_price' => '166.00','sell_price_inc_tax' => '182.60','created_at' => '2018-01-03 22:54:34','updated_at' => '2018-06-11 07:42:27','deleted_at' => NULL),
  array('id' => '27','name' => '6','product_id' => '8','sub_sku' => 'AS0008-1','product_variation_id' => '8','default_purchase_price' => '110.00','dpp_inc_tax' => '121.00','profit_percent' => '0.00','default_sell_price' => '110.00','sell_price_inc_tax' => '121.00','created_at' => '2018-01-03 23:10:10','updated_at' => '2018-06-11 07:41:16','deleted_at' => NULL),
  array('id' => '28','name' => '7','product_id' => '8','sub_sku' => 'AS0008-2','product_variation_id' => '8','default_purchase_price' => '110.00','dpp_inc_tax' => '121.00','profit_percent' => '0.00','default_sell_price' => '110.00','sell_price_inc_tax' => '121.00','created_at' => '2018-01-03 23:10:10','updated_at' => '2018-06-11 07:41:16','deleted_at' => NULL),
  array('id' => '29','name' => '8','product_id' => '8','sub_sku' => 'AS0008-3','product_variation_id' => '8','default_purchase_price' => '110.00','dpp_inc_tax' => '121.00','profit_percent' => '0.00','default_sell_price' => '110.00','sell_price_inc_tax' => '121.00','created_at' => '2018-01-03 23:10:10','updated_at' => '2018-06-11 07:41:16','deleted_at' => NULL),
  array('id' => '30','name' => '9','product_id' => '8','sub_sku' => 'AS0008-4','product_variation_id' => '8','default_purchase_price' => '110.00','dpp_inc_tax' => '121.00','profit_percent' => '0.00','default_sell_price' => '110.00','sell_price_inc_tax' => '121.00','created_at' => '2018-01-03 23:10:10','updated_at' => '2018-06-11 07:41:16','deleted_at' => NULL),
  array('id' => '31','name' => '6','product_id' => '9','sub_sku' => 'AS0009-1','product_variation_id' => '9','default_purchase_price' => '135.00','dpp_inc_tax' => '148.50','profit_percent' => '0.00','default_sell_price' => '135.00','sell_price_inc_tax' => '148.50','created_at' => '2018-01-03 23:11:57','updated_at' => '2018-06-11 07:42:43','deleted_at' => NULL),
  array('id' => '32','name' => '7','product_id' => '9','sub_sku' => 'AS0009-2','product_variation_id' => '9','default_purchase_price' => '135.00','dpp_inc_tax' => '148.50','profit_percent' => '0.00','default_sell_price' => '135.00','sell_price_inc_tax' => '148.50','created_at' => '2018-01-03 23:11:57','updated_at' => '2018-06-11 07:42:43','deleted_at' => NULL),
  array('id' => '33','name' => '8','product_id' => '9','sub_sku' => 'AS0009-3','product_variation_id' => '9','default_purchase_price' => '135.00','dpp_inc_tax' => '148.50','profit_percent' => '0.00','default_sell_price' => '135.00','sell_price_inc_tax' => '148.50','created_at' => '2018-01-03 23:11:57','updated_at' => '2018-06-11 07:42:43','deleted_at' => NULL),
  array('id' => '34','name' => '9','product_id' => '9','sub_sku' => 'AS0009-4','product_variation_id' => '9','default_purchase_price' => '135.00','dpp_inc_tax' => '148.50','profit_percent' => '0.00','default_sell_price' => '135.00','sell_price_inc_tax' => '148.50','created_at' => '2018-01-03 23:11:57','updated_at' => '2018-06-11 07:42:43','deleted_at' => NULL),
  array('id' => '35','name' => '5','product_id' => '10','sub_sku' => 'AS0010-1','product_variation_id' => '10','default_purchase_price' => '150.00','dpp_inc_tax' => '165.00','profit_percent' => '0.00','default_sell_price' => '150.00','sell_price_inc_tax' => '165.00','created_at' => '2018-01-03 23:13:02','updated_at' => '2018-06-11 07:41:35','deleted_at' => NULL),
  array('id' => '36','name' => '6','product_id' => '10','sub_sku' => 'AS0010-2','product_variation_id' => '10','default_purchase_price' => '150.00','dpp_inc_tax' => '165.00','profit_percent' => '0.00','default_sell_price' => '150.00','sell_price_inc_tax' => '165.00','created_at' => '2018-01-03 23:13:02','updated_at' => '2018-06-11 07:41:35','deleted_at' => NULL),
  array('id' => '37','name' => '7','product_id' => '10','sub_sku' => 'AS0010-3','product_variation_id' => '10','default_purchase_price' => '150.00','dpp_inc_tax' => '165.00','profit_percent' => '0.00','default_sell_price' => '150.00','sell_price_inc_tax' => '165.00','created_at' => '2018-01-03 23:13:02','updated_at' => '2018-06-11 07:41:35','deleted_at' => NULL),
  array('id' => '38','name' => '8','product_id' => '10','sub_sku' => 'AS0010-4','product_variation_id' => '10','default_purchase_price' => '150.00','dpp_inc_tax' => '165.00','profit_percent' => '0.00','default_sell_price' => '150.00','sell_price_inc_tax' => '165.00','created_at' => '2018-01-03 23:13:02','updated_at' => '2018-06-11 07:41:35','deleted_at' => NULL),
  array('id' => '39','name' => '9','product_id' => '10','sub_sku' => 'AS0010-5','product_variation_id' => '10','default_purchase_price' => '150.00','dpp_inc_tax' => '165.00','profit_percent' => '0.00','default_sell_price' => '150.00','sell_price_inc_tax' => '165.00','created_at' => '2018-01-03 23:13:02','updated_at' => '2018-06-11 07:41:35','deleted_at' => NULL),
  array('id' => '40','name' => 'DUMMY','product_id' => '11','sub_sku' => 'AS0011','product_variation_id' => '11','default_purchase_price' => '30.00','dpp_inc_tax' => '33.00','profit_percent' => '0.00','default_sell_price' => '30.00','sell_price_inc_tax' => '33.00','created_at' => '2018-01-03 23:14:35','updated_at' => '2018-06-11 07:36:08','deleted_at' => NULL),
  array('id' => '41','name' => 'DUMMY','product_id' => '12','sub_sku' => 'AS0012','product_variation_id' => '12','default_purchase_price' => '25.00','dpp_inc_tax' => '27.50','profit_percent' => '0.00','default_sell_price' => '25.00','sell_price_inc_tax' => '27.50','created_at' => '2018-01-03 23:15:50','updated_at' => '2018-06-11 07:35:50','deleted_at' => NULL),
  array('id' => '42','name' => 'M','product_id' => '13','sub_sku' => 'AS0013-1','product_variation_id' => '13','default_purchase_price' => '60.00','dpp_inc_tax' => '66.00','profit_percent' => '0.00','default_sell_price' => '60.00','sell_price_inc_tax' => '66.00','created_at' => '2018-01-03 23:17:59','updated_at' => '2018-06-11 07:40:19','deleted_at' => NULL),
  array('id' => '43','name' => 'L','product_id' => '13','sub_sku' => 'AS0013-2','product_variation_id' => '13','default_purchase_price' => '60.00','dpp_inc_tax' => '66.00','profit_percent' => '0.00','default_sell_price' => '60.00','sell_price_inc_tax' => '66.00','created_at' => '2018-01-03 23:17:59','updated_at' => '2018-06-11 07:40:19','deleted_at' => NULL),
  array('id' => '44','name' => 'XL','product_id' => '13','sub_sku' => 'AS0013-3','product_variation_id' => '13','default_purchase_price' => '60.00','dpp_inc_tax' => '66.00','profit_percent' => '0.00','default_sell_price' => '60.00','sell_price_inc_tax' => '66.00','created_at' => '2018-01-03 23:17:59','updated_at' => '2018-06-11 07:40:19','deleted_at' => NULL),
  array('id' => '45','name' => 'Gray','product_id' => '14','sub_sku' => 'AS0014-1','product_variation_id' => '14','default_purchase_price' => '700.00','dpp_inc_tax' => '770.00','profit_percent' => '25.00','default_sell_price' => '875.00','sell_price_inc_tax' => '962.50','created_at' => '2018-01-06 05:42:19','updated_at' => '2018-06-11 07:43:13','deleted_at' => NULL),
  array('id' => '46','name' => 'Black','product_id' => '14','sub_sku' => 'AS0014-2','product_variation_id' => '14','default_purchase_price' => '700.00','dpp_inc_tax' => '770.00','profit_percent' => '25.00','default_sell_price' => '875.00','sell_price_inc_tax' => '962.50','created_at' => '2018-01-06 05:42:19','updated_at' => '2018-06-11 07:43:13','deleted_at' => NULL),
  array('id' => '47','name' => '64 GB','product_id' => '14','sub_sku' => 'AS0014-1','product_variation_id' => '15','default_purchase_price' => '700.00','dpp_inc_tax' => '770.00','profit_percent' => '25.00','default_sell_price' => '875.00','sell_price_inc_tax' => '962.50','created_at' => '2018-01-06 05:44:14','updated_at' => '2018-06-11 07:43:13','deleted_at' => NULL),
  array('id' => '48','name' => '128 GB','product_id' => '14','sub_sku' => 'AS0014-2','product_variation_id' => '15','default_purchase_price' => '800.00','dpp_inc_tax' => '880.00','profit_percent' => '25.00','default_sell_price' => '1000.00','sell_price_inc_tax' => '1100.00','created_at' => '2018-01-06 05:44:14','updated_at' => '2018-06-11 07:43:13','deleted_at' => NULL),
  array('id' => '49','name' => 'White','product_id' => '15','sub_sku' => 'AS0015-1','product_variation_id' => '16','default_purchase_price' => '950.00','dpp_inc_tax' => '1045.00','profit_percent' => '25.00','default_sell_price' => '1187.50','sell_price_inc_tax' => '1306.25','created_at' => '2018-01-06 05:49:51','updated_at' => '2018-06-11 07:36:57','deleted_at' => NULL),
  array('id' => '50','name' => 'Gray','product_id' => '15','sub_sku' => 'AS0015-2','product_variation_id' => '16','default_purchase_price' => '950.00','dpp_inc_tax' => '1045.00','profit_percent' => '25.00','default_sell_price' => '1187.50','sell_price_inc_tax' => '1306.25','created_at' => '2018-01-06 05:49:51','updated_at' => '2018-06-11 07:36:57','deleted_at' => NULL),
  array('id' => '51','name' => 'Black','product_id' => '15','sub_sku' => 'AS0015-3','product_variation_id' => '16','default_purchase_price' => '950.00','dpp_inc_tax' => '1045.00','profit_percent' => '25.00','default_sell_price' => '1187.50','sell_price_inc_tax' => '1306.25','created_at' => '2018-01-06 05:49:51','updated_at' => '2018-06-11 07:36:57','deleted_at' => NULL),
  array('id' => '52','name' => '32 GB','product_id' => '15','sub_sku' => 'AS0015-1','product_variation_id' => '17','default_purchase_price' => '950.00','dpp_inc_tax' => '1045.00','profit_percent' => '25.00','default_sell_price' => '1187.50','sell_price_inc_tax' => '1306.25','created_at' => '2018-01-06 05:49:51','updated_at' => '2018-06-11 07:36:57','deleted_at' => NULL),
  array('id' => '53','name' => '64 GB','product_id' => '15','sub_sku' => 'AS0015-2','product_variation_id' => '17','default_purchase_price' => '1010.00','dpp_inc_tax' => '1111.00','profit_percent' => '25.00','default_sell_price' => '1262.50','sell_price_inc_tax' => '1388.75','created_at' => '2018-01-06 05:49:51','updated_at' => '2018-06-11 07:36:57','deleted_at' => NULL),
  array('id' => '54','name' => 'Gold','product_id' => '16','sub_sku' => 'AS0016-1','product_variation_id' => '18','default_purchase_price' => '350.00','dpp_inc_tax' => '350.00','profit_percent' => '25.00','default_sell_price' => '437.50','sell_price_inc_tax' => '437.50','created_at' => '2018-01-06 05:54:48','updated_at' => '2018-06-11 07:42:58','deleted_at' => NULL),
  array('id' => '55','name' => 'White','product_id' => '16','sub_sku' => 'AS0016-2','product_variation_id' => '18','default_purchase_price' => '350.00','dpp_inc_tax' => '350.00','profit_percent' => '25.00','default_sell_price' => '437.50','sell_price_inc_tax' => '437.50','created_at' => '2018-01-06 05:54:48','updated_at' => '2018-06-11 07:42:58','deleted_at' => NULL),
  array('id' => '56','name' => 'Black','product_id' => '16','sub_sku' => 'AS0016-3','product_variation_id' => '18','default_purchase_price' => '350.00','dpp_inc_tax' => '350.00','profit_percent' => '25.00','default_sell_price' => '437.50','sell_price_inc_tax' => '437.50','created_at' => '2018-01-06 05:54:48','updated_at' => '2018-06-11 07:42:58','deleted_at' => NULL),
  array('id' => '57','name' => 'Black','product_id' => '17','sub_sku' => 'AS0017-1','product_variation_id' => '19','default_purchase_price' => '350.00','dpp_inc_tax' => '350.00','profit_percent' => '25.00','default_sell_price' => '437.50','sell_price_inc_tax' => '437.50','created_at' => '2018-01-06 06:05:01','updated_at' => '2018-06-11 07:36:33','deleted_at' => NULL),
  array('id' => '58','name' => 'White','product_id' => '17','sub_sku' => 'AS0017-2','product_variation_id' => '19','default_purchase_price' => '350.00','dpp_inc_tax' => '350.00','profit_percent' => '25.00','default_sell_price' => '437.50','sell_price_inc_tax' => '437.50','created_at' => '2018-01-06 06:05:01','updated_at' => '2018-06-11 07:36:33','deleted_at' => NULL),
  array('id' => '59','name' => '256 GB','product_id' => '18','sub_sku' => 'AS0018-1','product_variation_id' => '20','default_purchase_price' => '1350.00','dpp_inc_tax' => '1350.00','profit_percent' => '25.00','default_sell_price' => '1687.50','sell_price_inc_tax' => '1687.50','created_at' => '2018-01-06 06:07:30','updated_at' => '2018-06-11 07:37:29','deleted_at' => NULL),
  array('id' => '60','name' => '500 GB','product_id' => '18','sub_sku' => 'AS0018-2','product_variation_id' => '20','default_purchase_price' => '1450.00','dpp_inc_tax' => '1450.00','profit_percent' => '25.00','default_sell_price' => '1812.50','sell_price_inc_tax' => '1812.50','created_at' => '2018-01-06 06:07:30','updated_at' => '2018-06-11 07:37:29','deleted_at' => NULL),
  array('id' => '61','name' => 'DUMMY','product_id' => '19','sub_sku' => 'AS0019','product_variation_id' => '21','default_purchase_price' => '8.00','dpp_inc_tax' => '8.00','profit_percent' => '25.00','default_sell_price' => '10.00','sell_price_inc_tax' => '10.00','created_at' => '2018-01-06 06:10:28','updated_at' => '2018-06-11 07:38:23','deleted_at' => NULL),
  array('id' => '62','name' => 'Gray','product_id' => '20','sub_sku' => 'AS0020-1','product_variation_id' => '22','default_purchase_price' => '25.00','dpp_inc_tax' => '27.50','profit_percent' => '25.00','default_sell_price' => '31.25','sell_price_inc_tax' => '34.38','created_at' => '2018-01-06 06:13:00','updated_at' => '2018-06-11 07:44:10','deleted_at' => NULL),
  array('id' => '63','name' => 'Black','product_id' => '20','sub_sku' => 'AS0020-2','product_variation_id' => '22','default_purchase_price' => '25.00','dpp_inc_tax' => '27.50','profit_percent' => '25.00','default_sell_price' => '31.25','sell_price_inc_tax' => '34.38','created_at' => '2018-01-06 06:13:00','updated_at' => '2018-06-11 07:44:10','deleted_at' => NULL),
  array('id' => '64','name' => 'DUMMY','product_id' => '21','sub_sku' => 'AS0021','product_variation_id' => '23','default_purchase_price' => '10.00','dpp_inc_tax' => '10.00','profit_percent' => '25.00','default_sell_price' => '12.50','sell_price_inc_tax' => '12.50','created_at' => '2018-01-06 06:16:35','updated_at' => '2018-06-11 07:42:13','deleted_at' => NULL),
  array('id' => '65','name' => 'DUMMY','product_id' => '22','sub_sku' => 'AS0022','product_variation_id' => '24','default_purchase_price' => '8.00','dpp_inc_tax' => '8.80','profit_percent' => '25.00','default_sell_price' => '10.00','sell_price_inc_tax' => '11.00','created_at' => '2018-01-06 06:25:09','updated_at' => '2018-06-11 07:38:37','deleted_at' => NULL),
  array('id' => '66','name' => 'DUMMY','product_id' => '23','sub_sku' => 'AS0023','product_variation_id' => '25','default_purchase_price' => '10.00','dpp_inc_tax' => '10.00','profit_percent' => '25.00','default_sell_price' => '12.50','sell_price_inc_tax' => '12.50','created_at' => '2018-01-06 06:26:27','updated_at' => '2018-06-11 07:43:51','deleted_at' => NULL),
  array('id' => '67','name' => 'DUMMY','product_id' => '24','sub_sku' => 'AS0024','product_variation_id' => '26','default_purchase_price' => '8.00','dpp_inc_tax' => '8.80','profit_percent' => '25.00','default_sell_price' => '10.00','sell_price_inc_tax' => '11.00','created_at' => '2018-01-06 06:31:22','updated_at' => '2018-06-11 07:38:53','deleted_at' => NULL),
  array('id' => '68','name' => 'DUMMY','product_id' => '25','sub_sku' => 'AS0025','product_variation_id' => '27','default_purchase_price' => '15.00','dpp_inc_tax' => '15.00','profit_percent' => '25.00','default_sell_price' => '18.75','sell_price_inc_tax' => '18.75','created_at' => '2018-01-06 06:32:23','updated_at' => '2018-06-11 07:39:09','deleted_at' => NULL),
  array('id' => '69','name' => 'DUMMY','product_id' => '26','sub_sku' => 'AS0026','product_variation_id' => '28','default_purchase_price' => '5.00','dpp_inc_tax' => '5.00','profit_percent' => '25.00','default_sell_price' => '6.25','sell_price_inc_tax' => '6.25','created_at' => '2018-01-06 06:35:51','updated_at' => '2018-06-11 07:41:51','deleted_at' => NULL),
  array('id' => '70','name' => 'DUMMY','product_id' => '27','sub_sku' => 'AS0027','product_variation_id' => '29','default_purchase_price' => '20.00','dpp_inc_tax' => '22.00','profit_percent' => '25.00','default_sell_price' => '25.00','sell_price_inc_tax' => '27.50','created_at' => '2018-01-06 06:43:16','updated_at' => '2018-06-11 07:38:01','deleted_at' => NULL),
  array('id' => '71','name' => 'DUMMY','product_id' => '28','sub_sku' => 'AS0028','product_variation_id' => '30','default_purchase_price' => '10.00','dpp_inc_tax' => '11.00','profit_percent' => '25.00','default_sell_price' => '12.50','sell_price_inc_tax' => '13.75','created_at' => '2018-01-06 06:45:47','updated_at' => '2018-06-11 07:37:45','deleted_at' => NULL),
  array('id' => '72','name' => 'DUMMY','product_id' => '29','sub_sku' => 'AS0029','product_variation_id' => '31','default_purchase_price' => '12.00','dpp_inc_tax' => '12.00','profit_percent' => '25.00','default_sell_price' => '15.00','sell_price_inc_tax' => '15.00','created_at' => '2018-01-06 06:46:53','updated_at' => '2018-06-11 07:44:34','deleted_at' => NULL),
  array('id' => '73','name' => 'DUMMY','product_id' => '30','sub_sku' => 'AS0030','product_variation_id' => '32','default_purchase_price' => '40.00','dpp_inc_tax' => '44.00','profit_percent' => '25.00','default_sell_price' => '50.00','sell_price_inc_tax' => '55.00','created_at' => '2018-01-06 06:48:59','updated_at' => '2018-06-11 07:39:59','deleted_at' => NULL),
  array('id' => '74','name' => 'DUMMY','product_id' => '31','sub_sku' => 'AP0031','product_variation_id' => '33','default_purchase_price' => '7.00','dpp_inc_tax' => '7.00','profit_percent' => '25.00','default_sell_price' => '8.75','sell_price_inc_tax' => '8.75','created_at' => '2018-04-10 10:06:29','updated_at' => '2018-04-10 10:06:29','deleted_at' => NULL),
  array('id' => '75','name' => 'DUMMY','product_id' => '32','sub_sku' => 'AP0032','product_variation_id' => '34','default_purchase_price' => '12.00','dpp_inc_tax' => '12.00','profit_percent' => '25.00','default_sell_price' => '15.00','sell_price_inc_tax' => '15.00','created_at' => '2018-04-10 10:07:52','updated_at' => '2018-04-10 10:07:52','deleted_at' => NULL),
  array('id' => '76','name' => 'DUMMY','product_id' => '33','sub_sku' => 'AP0033','product_variation_id' => '35','default_purchase_price' => '12.00','dpp_inc_tax' => '12.00','profit_percent' => '25.00','default_sell_price' => '15.00','sell_price_inc_tax' => '15.00','created_at' => '2018-04-10 10:09:45','updated_at' => '2018-04-10 10:09:45','deleted_at' => NULL),
  array('id' => '77','name' => 'DUMMY','product_id' => '34','sub_sku' => 'AP0034','product_variation_id' => '36','default_purchase_price' => '6.00','dpp_inc_tax' => '6.00','profit_percent' => '25.00','default_sell_price' => '7.50','sell_price_inc_tax' => '7.50','created_at' => '2018-04-10 10:10:59','updated_at' => '2018-04-10 10:10:59','deleted_at' => NULL),
  array('id' => '78','name' => 'DUMMY','product_id' => '35','sub_sku' => 'AP0035','product_variation_id' => '37','default_purchase_price' => '7.00','dpp_inc_tax' => '7.00','profit_percent' => '25.00','default_sell_price' => '8.75','sell_price_inc_tax' => '8.75','created_at' => '2018-04-10 10:12:53','updated_at' => '2018-04-10 10:12:53','deleted_at' => NULL),
  array('id' => '79','name' => 'DUMMY','product_id' => '36','sub_sku' => 'AP0036','product_variation_id' => '38','default_purchase_price' => '9.00','dpp_inc_tax' => '9.00','profit_percent' => '25.00','default_sell_price' => '11.25','sell_price_inc_tax' => '11.25','created_at' => '2018-04-10 10:14:18','updated_at' => '2018-04-10 10:14:18','deleted_at' => NULL),
  array('id' => '80','name' => 'DUMMY','product_id' => '37','sub_sku' => 'AP0037','product_variation_id' => '39','default_purchase_price' => '12.00','dpp_inc_tax' => '12.00','profit_percent' => '25.00','default_sell_price' => '15.00','sell_price_inc_tax' => '15.00','created_at' => '2018-04-10 10:31:29','updated_at' => '2018-04-10 10:31:29','deleted_at' => NULL),
  array('id' => '81','name' => 'DUMMY','product_id' => '38','sub_sku' => 'AP0038','product_variation_id' => '40','default_purchase_price' => '15.00','dpp_inc_tax' => '15.00','profit_percent' => '25.00','default_sell_price' => '18.75','sell_price_inc_tax' => '18.75','created_at' => '2018-04-10 10:32:35','updated_at' => '2018-04-10 10:32:35','deleted_at' => NULL),
  array('id' => '82','name' => 'DUMMY','product_id' => '39','sub_sku' => 'AP0039','product_variation_id' => '41','default_purchase_price' => '12.00','dpp_inc_tax' => '12.00','profit_percent' => '25.00','default_sell_price' => '15.00','sell_price_inc_tax' => '15.00','created_at' => '2018-04-10 10:33:26','updated_at' => '2018-04-10 10:33:26','deleted_at' => NULL),
  array('id' => '83','name' => 'DUMMY','product_id' => '40','sub_sku' => 'AP0040','product_variation_id' => '42','default_purchase_price' => '8.00','dpp_inc_tax' => '8.00','profit_percent' => '25.00','default_sell_price' => '10.00','sell_price_inc_tax' => '10.00','created_at' => '2018-04-10 10:34:32','updated_at' => '2018-04-10 10:34:49','deleted_at' => NULL),
  array('id' => '84','name' => 'DUMMY','product_id' => '41','sub_sku' => 'AE0041','product_variation_id' => '43','default_purchase_price' => '500.00','dpp_inc_tax' => '500.00','profit_percent' => '25.00','default_sell_price' => '625.00','sell_price_inc_tax' => '625.00','created_at' => '2018-04-10 11:08:27','updated_at' => '2018-04-10 11:08:27','deleted_at' => NULL),
  array('id' => '85','name' => 'DUMMY','product_id' => '42','sub_sku' => 'AE0042','product_variation_id' => '44','default_purchase_price' => '520.00','dpp_inc_tax' => '520.00','profit_percent' => '25.00','default_sell_price' => '650.00','sell_price_inc_tax' => '650.00','created_at' => '2018-04-10 11:15:52','updated_at' => '2018-04-10 11:51:21','deleted_at' => NULL),
  array('id' => '86','name' => 'DUMMY','product_id' => '43','sub_sku' => 'AE0043','product_variation_id' => '45','default_purchase_price' => '400.00','dpp_inc_tax' => '400.00','profit_percent' => '25.00','default_sell_price' => '500.00','sell_price_inc_tax' => '500.00','created_at' => '2018-04-10 11:18:01','updated_at' => '2018-04-10 11:18:01','deleted_at' => NULL),
  array('id' => '87','name' => 'DUMMY','product_id' => '44','sub_sku' => 'AE0044','product_variation_id' => '46','default_purchase_price' => '195.00','dpp_inc_tax' => '195.00','profit_percent' => '25.00','default_sell_price' => '243.75','sell_price_inc_tax' => '243.75','created_at' => '2018-04-10 11:19:10','updated_at' => '2018-04-10 11:19:10','deleted_at' => NULL),
  array('id' => '88','name' => 'DUMMY','product_id' => '45','sub_sku' => 'AE0045','product_variation_id' => '47','default_purchase_price' => '300.00','dpp_inc_tax' => '300.00','profit_percent' => '25.00','default_sell_price' => '375.00','sell_price_inc_tax' => '375.00','created_at' => '2018-04-10 11:20:22','updated_at' => '2018-04-10 11:20:22','deleted_at' => NULL),
  array('id' => '89','name' => 'DUMMY','product_id' => '46','sub_sku' => 'AE0046','product_variation_id' => '48','default_purchase_price' => '321.00','dpp_inc_tax' => '321.00','profit_percent' => '25.00','default_sell_price' => '401.25','sell_price_inc_tax' => '401.25','created_at' => '2018-04-10 11:22:04','updated_at' => '2018-04-10 11:22:04','deleted_at' => NULL),
  array('id' => '90','name' => 'DUMMY','product_id' => '47','sub_sku' => 'AE0047','product_variation_id' => '49','default_purchase_price' => '255.00','dpp_inc_tax' => '255.00','profit_percent' => '25.00','default_sell_price' => '318.75','sell_price_inc_tax' => '318.75','created_at' => '2018-04-10 11:23:45','updated_at' => '2018-04-10 11:23:45','deleted_at' => NULL),
  array('id' => '91','name' => 'DUMMY','product_id' => '48','sub_sku' => 'AE0048','product_variation_id' => '50','default_purchase_price' => '850.00','dpp_inc_tax' => '850.00','profit_percent' => '25.00','default_sell_price' => '1062.50','sell_price_inc_tax' => '1062.50','created_at' => '2018-04-10 11:24:42','updated_at' => '2018-04-10 11:52:07','deleted_at' => NULL),
  array('id' => '92','name' => 'DUMMY','product_id' => '49','sub_sku' => 'AE0049','product_variation_id' => '51','default_purchase_price' => '1500.00','dpp_inc_tax' => '1500.00','profit_percent' => '25.00','default_sell_price' => '1875.00','sell_price_inc_tax' => '1875.00','created_at' => '2018-04-10 11:25:55','updated_at' => '2018-04-10 11:25:55','deleted_at' => NULL),
  array('id' => '93','name' => 'DUMMY','product_id' => '50','sub_sku' => 'AE0050','product_variation_id' => '52','default_purchase_price' => '630.00','dpp_inc_tax' => '630.00','profit_percent' => '25.00','default_sell_price' => '787.50','sell_price_inc_tax' => '787.50','created_at' => '2018-04-10 11:34:32','updated_at' => '2018-04-10 11:34:32','deleted_at' => NULL),
  array('id' => '94','name' => 'DUMMY','product_id' => '51','sub_sku' => 'AS0051','product_variation_id' => '53','default_purchase_price' => '100.00','dpp_inc_tax' => '100.00','profit_percent' => '25.00','default_sell_price' => '125.00','sell_price_inc_tax' => '125.00','created_at' => '2018-04-10 12:34:57','updated_at' => '2018-04-10 12:34:57','deleted_at' => NULL),
  array('id' => '95','name' => 'DUMMY','product_id' => '52','sub_sku' => 'AS0052','product_variation_id' => '54','default_purchase_price' => '80.00','dpp_inc_tax' => '80.00','profit_percent' => '25.00','default_sell_price' => '100.00','sell_price_inc_tax' => '100.00','created_at' => '2018-04-10 12:35:55','updated_at' => '2018-04-10 12:35:55','deleted_at' => NULL),
  array('id' => '96','name' => 'DUMMY','product_id' => '53','sub_sku' => 'AS0053','product_variation_id' => '55','default_purchase_price' => '105.00','dpp_inc_tax' => '105.00','profit_percent' => '25.00','default_sell_price' => '131.25','sell_price_inc_tax' => '131.25','created_at' => '2018-04-10 12:39:15','updated_at' => '2018-04-10 12:39:15','deleted_at' => NULL),
  array('id' => '97','name' => 'DUMMY','product_id' => '54','sub_sku' => 'AS0054','product_variation_id' => '56','default_purchase_price' => '10.00','dpp_inc_tax' => '10.00','profit_percent' => '25.00','default_sell_price' => '12.50','sell_price_inc_tax' => '12.50','created_at' => '2018-04-10 12:54:16','updated_at' => '2018-04-10 12:54:16','deleted_at' => NULL),
  array('id' => '98','name' => 'DUMMY','product_id' => '55','sub_sku' => 'AS0055','product_variation_id' => '57','default_purchase_price' => '8.00','dpp_inc_tax' => '8.00','profit_percent' => '25.00','default_sell_price' => '10.00','sell_price_inc_tax' => '10.00','created_at' => '2018-04-10 12:56:18','updated_at' => '2018-04-10 12:56:18','deleted_at' => NULL),
  array('id' => '99','name' => 'DUMMY','product_id' => '56','sub_sku' => 'AS0056','product_variation_id' => '58','default_purchase_price' => '150.00','dpp_inc_tax' => '150.00','profit_percent' => '25.00','default_sell_price' => '187.50','sell_price_inc_tax' => '187.50','created_at' => '2018-04-10 13:01:59','updated_at' => '2018-04-10 13:01:59','deleted_at' => NULL),
  array('id' => '100','name' => 'DUMMY','product_id' => '57','sub_sku' => 'AS0057','product_variation_id' => '59','default_purchase_price' => '20.00','dpp_inc_tax' => '20.00','profit_percent' => '25.00','default_sell_price' => '25.00','sell_price_inc_tax' => '25.00','created_at' => '2018-04-10 13:03:01','updated_at' => '2018-04-10 13:03:01','deleted_at' => NULL),
  array('id' => '101','name' => 'DUMMY','product_id' => '58','sub_sku' => 'AS0058','product_variation_id' => '60','default_purchase_price' => '20.00','dpp_inc_tax' => '20.00','profit_percent' => '25.00','default_sell_price' => '25.00','sell_price_inc_tax' => '25.00','created_at' => '2018-04-10 13:03:37','updated_at' => '2018-04-10 13:03:37','deleted_at' => NULL),
  array('id' => '102','name' => 'DUMMY','product_id' => '59','sub_sku' => 'AS0059','product_variation_id' => '61','default_purchase_price' => '15.00','dpp_inc_tax' => '15.00','profit_percent' => '25.00','default_sell_price' => '18.75','sell_price_inc_tax' => '18.75','created_at' => '2018-04-10 13:06:45','updated_at' => '2018-04-10 13:06:45','deleted_at' => NULL),
  array('id' => '103','name' => 'DUMMY','product_id' => '60','sub_sku' => 'AS0060','product_variation_id' => '62','default_purchase_price' => '15.00','dpp_inc_tax' => '15.00','profit_percent' => '25.00','default_sell_price' => '18.75','sell_price_inc_tax' => '18.75','created_at' => '2018-04-10 13:07:08','updated_at' => '2018-04-10 13:07:08','deleted_at' => NULL),
  array('id' => '104','name' => 'DUMMY','product_id' => '61','sub_sku' => 'AS0061','product_variation_id' => '63','default_purchase_price' => '34.00','dpp_inc_tax' => '34.00','profit_percent' => '25.00','default_sell_price' => '42.50','sell_price_inc_tax' => '42.50','created_at' => '2018-06-11 21:57:41','updated_at' => '2018-06-11 21:57:41','deleted_at' => NULL),
  array('id' => '105','name' => 'DUMMY','product_id' => '62','sub_sku' => 'AS0062','product_variation_id' => '64','default_purchase_price' => '35.00','dpp_inc_tax' => '35.00','profit_percent' => '25.00','default_sell_price' => '43.75','sell_price_inc_tax' => '43.75','created_at' => '2018-06-11 22:02:17','updated_at' => '2018-06-11 22:02:17','deleted_at' => NULL),
  array('id' => '106','name' => 'DUMMY','product_id' => '63','sub_sku' => 'AS0063','product_variation_id' => '65','default_purchase_price' => '10.00','dpp_inc_tax' => '10.00','profit_percent' => '25.00','default_sell_price' => '12.50','sell_price_inc_tax' => '12.50','created_at' => '2018-06-11 22:08:12','updated_at' => '2018-06-11 22:08:12','deleted_at' => NULL),
  array('id' => '107','name' => 'DUMMY','product_id' => '64','sub_sku' => 'AS0064','product_variation_id' => '66','default_purchase_price' => '10.00','dpp_inc_tax' => '10.00','profit_percent' => '25.00','default_sell_price' => '12.50','sell_price_inc_tax' => '12.50','created_at' => '2018-06-11 22:10:34','updated_at' => '2018-06-11 22:10:34','deleted_at' => NULL),
  array('id' => '108','name' => 'DUMMY','product_id' => '65','sub_sku' => 'AS0065','product_variation_id' => '67','default_purchase_price' => '10.00','dpp_inc_tax' => '10.00','profit_percent' => '25.00','default_sell_price' => '12.50','sell_price_inc_tax' => '12.50','created_at' => '2018-06-11 22:14:00','updated_at' => '2018-06-11 22:14:30','deleted_at' => NULL),
  array('id' => '109','name' => 'DUMMY','product_id' => '66','sub_sku' => 'AR0066','product_variation_id' => '68','default_purchase_price' => '15.00','dpp_inc_tax' => '15.00','profit_percent' => '25.00','default_sell_price' => '18.75','sell_price_inc_tax' => '18.75','created_at' => '2018-07-13 06:30:31','updated_at' => '2018-07-13 06:30:31','deleted_at' => NULL),
  array('id' => '110','name' => 'DUMMY','product_id' => '67','sub_sku' => 'AR0067','product_variation_id' => '69','default_purchase_price' => '8.00','dpp_inc_tax' => '8.00','profit_percent' => '25.00','default_sell_price' => '10.00','sell_price_inc_tax' => '10.00','created_at' => '2018-07-13 06:34:47','updated_at' => '2018-07-13 06:34:47','deleted_at' => NULL),
  array('id' => '111','name' => 'DUMMY','product_id' => '68','sub_sku' => 'AR0068','product_variation_id' => '70','default_purchase_price' => '11.00','dpp_inc_tax' => '11.00','profit_percent' => '25.00','default_sell_price' => '13.75','sell_price_inc_tax' => '13.75','created_at' => '2018-07-13 06:38:55','updated_at' => '2018-07-13 06:38:55','deleted_at' => NULL),
  array('id' => '112','name' => 'DUMMY','product_id' => '69','sub_sku' => 'AR0069','product_variation_id' => '71','default_purchase_price' => '12.00','dpp_inc_tax' => '12.00','profit_percent' => '25.00','default_sell_price' => '15.00','sell_price_inc_tax' => '15.00','created_at' => '2018-07-13 06:45:51','updated_at' => '2018-07-13 06:45:51','deleted_at' => NULL),
  array('id' => '113','name' => 'DUMMY','product_id' => '70','sub_sku' => 'AR0070','product_variation_id' => '72','default_purchase_price' => '12.00','dpp_inc_tax' => '12.00','profit_percent' => '25.00','default_sell_price' => '15.00','sell_price_inc_tax' => '15.00','created_at' => '2018-07-13 06:57:37','updated_at' => '2018-07-13 06:57:37','deleted_at' => NULL),
  array('id' => '114','name' => 'DUMMY','product_id' => '71','sub_sku' => 'AR0071','product_variation_id' => '73','default_purchase_price' => '17.00','dpp_inc_tax' => '17.00','profit_percent' => '25.00','default_sell_price' => '21.25','sell_price_inc_tax' => '21.25','created_at' => '2018-07-13 07:00:41','updated_at' => '2018-07-13 07:00:41','deleted_at' => NULL),
  array('id' => '115','name' => 'DUMMY','product_id' => '72','sub_sku' => 'AR0072','product_variation_id' => '74','default_purchase_price' => '18.00','dpp_inc_tax' => '18.00','profit_percent' => '25.00','default_sell_price' => '22.50','sell_price_inc_tax' => '22.50','created_at' => '2018-07-13 07:05:03','updated_at' => '2018-07-13 07:05:03','deleted_at' => NULL),
  array('id' => '116','name' => 'DUMMY','product_id' => '73','sub_sku' => 'AR0073','product_variation_id' => '75','default_purchase_price' => '20.00','dpp_inc_tax' => '20.00','profit_percent' => '25.00','default_sell_price' => '25.00','sell_price_inc_tax' => '25.00','created_at' => '2018-07-13 07:07:29','updated_at' => '2018-07-13 07:07:29','deleted_at' => NULL),
  array('id' => '117','name' => 'DUMMY','product_id' => '74','sub_sku' => 'AR0074','product_variation_id' => '76','default_purchase_price' => '7.00','dpp_inc_tax' => '7.00','profit_percent' => '25.00','default_sell_price' => '8.75','sell_price_inc_tax' => '8.75','created_at' => '2018-07-13 07:10:45','updated_at' => '2018-07-13 07:10:45','deleted_at' => NULL),
  array('id' => '118','name' => 'DUMMY','product_id' => '75','sub_sku' => 'AR0075','product_variation_id' => '77','default_purchase_price' => '8.00','dpp_inc_tax' => '8.00','profit_percent' => '25.00','default_sell_price' => '10.00','sell_price_inc_tax' => '10.00','created_at' => '2018-07-13 07:13:09','updated_at' => '2018-07-13 07:13:09','deleted_at' => NULL),
  array('id' => '119','name' => 'DUMMY','product_id' => '76','sub_sku' => 'AR0076','product_variation_id' => '78','default_purchase_price' => '8.00','dpp_inc_tax' => '8.00','profit_percent' => '25.00','default_sell_price' => '10.00','sell_price_inc_tax' => '10.00','created_at' => '2018-07-13 07:18:33','updated_at' => '2018-07-13 07:18:33','deleted_at' => NULL),
  array('id' => '120','name' => 'DUMMY','product_id' => '77','sub_sku' => 'AR0077','product_variation_id' => '79','default_purchase_price' => '3.00','dpp_inc_tax' => '3.00','profit_percent' => '25.00','default_sell_price' => '3.75','sell_price_inc_tax' => '3.75','created_at' => '2018-07-13 07:24:22','updated_at' => '2018-07-13 07:28:56','deleted_at' => NULL),
  array('id' => '121','name' => 'Bacon','product_id' => '78','sub_sku' => 'AR0078-1','product_variation_id' => '80','default_purchase_price' => '2.00','dpp_inc_tax' => '2.00','profit_percent' => '0.00','default_sell_price' => '2.00','sell_price_inc_tax' => '2.00','created_at' => '2018-07-16 07:58:04','updated_at' => '2018-07-16 07:58:51','deleted_at' => NULL),
  array('id' => '122','name' => 'Black olives','product_id' => '78','sub_sku' => 'AR0078-2','product_variation_id' => '80','default_purchase_price' => '1.00','dpp_inc_tax' => '1.00','profit_percent' => '0.00','default_sell_price' => '1.00','sell_price_inc_tax' => '1.00','created_at' => '2018-07-16 07:58:33','updated_at' => '2018-07-16 07:58:51','deleted_at' => NULL),
  array('id' => '123','name' => 'Green peppers','product_id' => '78','sub_sku' => 'AR0078-3','product_variation_id' => '80','default_purchase_price' => '1.00','dpp_inc_tax' => '1.00','profit_percent' => '0.00','default_sell_price' => '1.00','sell_price_inc_tax' => '1.00','created_at' => '2018-07-16 07:58:51','updated_at' => '2018-07-16 07:58:51','deleted_at' => NULL),
  array('id' => '124','name' => 'Cheese','product_id' => '79','sub_sku' => 'AR0079-1','product_variation_id' => '81','default_purchase_price' => '2.00','dpp_inc_tax' => '2.00','profit_percent' => '0.00','default_sell_price' => '2.00','sell_price_inc_tax' => '2.00','created_at' => '2018-07-16 08:05:37','updated_at' => '2018-07-16 08:06:52','deleted_at' => NULL),
  array('id' => '125','name' => 'Vegies','product_id' => '79','sub_sku' => 'AR0079-2','product_variation_id' => '81','default_purchase_price' => '1.00','dpp_inc_tax' => '1.00','profit_percent' => '0.00','default_sell_price' => '1.00','sell_price_inc_tax' => '1.00','created_at' => '2018-07-16 08:05:37','updated_at' => '2018-07-16 08:06:52','deleted_at' => NULL),
  array('id' => '126','name' => 'Bacon','product_id' => '79','sub_sku' => 'AR0079-3','product_variation_id' => '81','default_purchase_price' => '2.00','dpp_inc_tax' => '2.00','profit_percent' => '0.00','default_sell_price' => '2.00','sell_price_inc_tax' => '2.00','created_at' => '2018-07-16 08:05:37','updated_at' => '2018-07-16 08:06:52','deleted_at' => NULL),
  array('id' => '127','name' => 'Chocolate','product_id' => '79','sub_sku' => 'AR0079-4','product_variation_id' => '81','default_purchase_price' => '2.00','dpp_inc_tax' => '2.00','profit_percent' => '0.00','default_sell_price' => '2.00','sell_price_inc_tax' => '2.00','created_at' => '2018-07-16 08:06:52','updated_at' => '2018-07-16 08:06:52','deleted_at' => NULL)
);

DB::table('variations')->insert($variations);

$res_product_modifier_sets = array(
  array('modifier_set_id' => '78','product_id' => '72'),
  array('modifier_set_id' => '78','product_id' => '73'),
  array('modifier_set_id' => '79','product_id' => '73'),
  array('modifier_set_id' => '79','product_id' => '69'),
  array('modifier_set_id' => '79','product_id' => '72'),
  array('modifier_set_id' => '79','product_id' => '75'),
  array('modifier_set_id' => '79','product_id' => '68')
);

DB::table('res_product_modifier_sets')->insert($res_product_modifier_sets);

        DB::insert("INSERT INTO variation_templates (id, name, business_id, 
        			created_at, updated_at) VALUES
					(1, 'Size (Tshirts)', 1, '2018-01-04 02:52:13', '2018-01-04 02:52:13'),
					(2, 'Size (Shoes)', 1, '2018-01-04 02:53:21', '2018-01-04 02:53:21'),
					(3, 'Waist Size (Jeans)', 1, '2018-01-04 02:54:34', '2018-01-04 02:54:34'),
					(4, 'Color', 1, '2018-01-06 12:42:52', '2018-01-06 12:42:52')");

        DB::insert("INSERT INTO variation_value_templates (id, name, variation_template_id, 
        			created_at, updated_at) VALUES
					(1, 'S', 1, '2018-01-04 02:52:13', '2018-01-04 02:52:13'),
					(2, 'M', 1, '2018-01-04 02:52:13', '2018-01-04 02:52:13'),
					(3, 'L', 1, '2018-01-04 02:52:13', '2018-01-04 02:52:13'),
					(4, 'XL', 1, '2018-01-04 02:52:13', '2018-01-04 02:52:13'),
					(5, '5', 2, '2018-01-04 02:53:21', '2018-01-04 02:53:21'),
					(6, '6', 2, '2018-01-04 02:53:21', '2018-01-04 02:53:21'),
					(7, '7', 2, '2018-01-04 02:53:21', '2018-01-04 02:53:21'),
					(8, '8', 2, '2018-01-04 02:53:21', '2018-01-04 02:53:21'),
					(9, '9', 2, '2018-01-04 02:53:21', '2018-01-04 02:53:21'),
					(10, '28', 3, '2018-01-04 02:54:34', '2018-01-04 02:54:34'),
					(11, '30', 3, '2018-01-04 02:54:34', '2018-01-04 02:54:34'),
					(12, '32', 3, '2018-01-04 02:54:34', '2018-01-04 02:54:34'),
					(13, '34', 3, '2018-01-04 02:54:35', '2018-01-04 02:54:35'),
					(14, '36', 3, '2018-01-04 02:54:35', '2018-01-04 02:54:35'),
					(16, 'Black', 4, '2018-01-06 12:43:17', '2018-01-06 12:43:17'),
					(17, 'Blue', 4, '2018-01-06 12:43:17', '2018-01-06 12:43:17'),
					(18, 'Brown', 4, '2018-01-06 12:43:17', '2018-01-06 12:43:17'),
					(19, 'Grey', 4, '2018-01-06 12:43:17', '2018-01-06 12:43:17'),
					(20, 'Gold', 4, '2018-01-06 12:43:17', '2018-01-06 12:43:17')");

$purchase_lines = array(
  array('id' => '1','transaction_id' => '1','product_id' => '2','variation_id' => '2','quantity' => '100','pp_without_discount' => '70.00','discount_percent' => '0.00','purchase_price' => '70.00','purchase_price_inc_tax' => '77.00','item_tax' => '7.00','tax_id' => '1','quantity_sold' => '50.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-01-06 06:57:11','updated_at' => '2018-06-13 11:39:08'),
  array('id' => '2','transaction_id' => '1','product_id' => '2','variation_id' => '3','quantity' => '150','pp_without_discount' => '70.00','discount_percent' => '0.00','purchase_price' => '70.00','purchase_price_inc_tax' => '77.00','item_tax' => '7.00','tax_id' => '1','quantity_sold' => '60.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-01-06 06:57:11','updated_at' => '2018-06-13 11:39:08'),
  array('id' => '3','transaction_id' => '1','product_id' => '2','variation_id' => '4','quantity' => '150','pp_without_discount' => '70.00','discount_percent' => '0.00','purchase_price' => '70.00','purchase_price_inc_tax' => '77.00','item_tax' => '7.00','tax_id' => '1','quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-01-06 06:57:11','updated_at' => '2018-06-13 11:39:07'),
  array('id' => '4','transaction_id' => '1','product_id' => '2','variation_id' => '5','quantity' => '150','pp_without_discount' => '72.00','discount_percent' => '0.00','purchase_price' => '72.00','purchase_price_inc_tax' => '79.20','item_tax' => '7.20','tax_id' => '1','quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-01-06 06:57:11','updated_at' => '2018-06-13 11:39:07'),
  array('id' => '5','transaction_id' => '1','product_id' => '2','variation_id' => '6','quantity' => '100','pp_without_discount' => '72.00','discount_percent' => '0.00','purchase_price' => '72.00','purchase_price_inc_tax' => '79.20','item_tax' => '7.20','tax_id' => '1','quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-01-06 06:57:11','updated_at' => '2018-06-13 11:39:07'),
  array('id' => '6','transaction_id' => '2','product_id' => '14','variation_id' => '47','quantity' => '100','pp_without_discount' => '700.00','discount_percent' => '0.00','purchase_price' => '700.00','purchase_price_inc_tax' => '770.00','item_tax' => '70.00','tax_id' => '1','quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-01-06 06:58:10','updated_at' => '2018-06-13 11:39:07'),
  array('id' => '7','transaction_id' => '3','product_id' => '28','variation_id' => '71','quantity' => '500','pp_without_discount' => '10.00','discount_percent' => '0.00','purchase_price' => '10.00','purchase_price_inc_tax' => '11.00','item_tax' => '1.00','tax_id' => '1','quantity_sold' => '30.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-01-06 07:02:22','updated_at' => '2018-06-13 11:39:08'),
  array('id' => '8','transaction_id' => '4','product_id' => '21','variation_id' => '64','quantity' => '200','pp_without_discount' => '10.00','discount_percent' => '0.00','purchase_price' => '10.00','purchase_price_inc_tax' => '10.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '60.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-01-06 07:03:12','updated_at' => '2018-06-13 11:39:08'),
  array('id' => '9','transaction_id' => '5','product_id' => '27','variation_id' => '70','quantity' => '500','pp_without_discount' => '20.00','discount_percent' => '0.00','purchase_price' => '20.00','purchase_price_inc_tax' => '22.00','item_tax' => '2.00','tax_id' => '1','quantity_sold' => '30.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-01-06 07:05:26','updated_at' => '2018-06-13 11:39:07'),
  array('id' => '10','transaction_id' => '11','product_id' => '34','variation_id' => '77','quantity' => '50','pp_without_discount' => '6.00','discount_percent' => '0.00','purchase_price' => '6.00','purchase_price_inc_tax' => '6.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '10.00','quantity_adjusted' => '0.00','mfg_date' => '2018-04-10','exp_date' => $next_12_month,'lot_number' => NULL,'created_at' => '2018-04-10 10:18:16','updated_at' => '2018-06-13 11:39:08'),
  array('id' => '11','transaction_id' => '12','product_id' => '32','variation_id' => '75','quantity' => '100','pp_without_discount' => '12.00','discount_percent' => '0.00','purchase_price' => '12.00','purchase_price_inc_tax' => '12.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '7.00','quantity_adjusted' => '0.00','mfg_date' => '2018-04-12','exp_date' => $next_6_month,'lot_number' => NULL,'created_at' => '2018-04-10 10:19:40','updated_at' => '2018-06-13 11:39:08'),
  array('id' => '12','transaction_id' => '13','product_id' => '36','variation_id' => '79','quantity' => '150','pp_without_discount' => '9.00','discount_percent' => '0.00','purchase_price' => '9.00','purchase_price_inc_tax' => '9.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => '2018-03-30','exp_date' => $next_12_month,'lot_number' => NULL,'created_at' => '2018-04-10 10:20:41','updated_at' => '2018-06-13 11:39:07'),
  array('id' => '13','transaction_id' => '14','product_id' => '33','variation_id' => '76','quantity' => '180','pp_without_discount' => '12.00','discount_percent' => '0.00','purchase_price' => '12.00','purchase_price_inc_tax' => '12.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '27.00','quantity_adjusted' => '0.00','mfg_date' => '2018-04-10','exp_date' => $yesterday,'lot_number' => NULL,'created_at' => '2018-04-10 10:21:38','updated_at' => '2018-06-13 11:39:08'),
  array('id' => '14','transaction_id' => '18','product_id' => '46','variation_id' => '89','quantity' => '30','pp_without_discount' => '321.00','discount_percent' => '0.00','purchase_price' => '321.00','purchase_price_inc_tax' => '321.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-04-10 11:39:54','updated_at' => '2018-06-13 11:39:07'),
  array('id' => '15','transaction_id' => '19','product_id' => '41','variation_id' => '84','quantity' => '40','pp_without_discount' => '500.00','discount_percent' => '0.00','purchase_price' => '500.00','purchase_price_inc_tax' => '500.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '26.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-04-10 11:40:51','updated_at' => '2018-06-13 11:39:09'),
  array('id' => '16','transaction_id' => '20','product_id' => '45','variation_id' => '88','quantity' => '45','pp_without_discount' => '300.00','discount_percent' => '0.00','purchase_price' => '300.00','purchase_price_inc_tax' => '300.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-04-10 11:41:45','updated_at' => '2018-06-13 11:39:07'),
  array('id' => '17','transaction_id' => '21','product_id' => '44','variation_id' => '87','quantity' => '100','pp_without_discount' => '195.00','discount_percent' => '0.00','purchase_price' => '195.00','purchase_price_inc_tax' => '195.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '20.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-04-10 11:42:34','updated_at' => '2018-06-13 11:39:09'),
  array('id' => '18','transaction_id' => '22','product_id' => '43','variation_id' => '86','quantity' => '30','pp_without_discount' => '400.00','discount_percent' => '0.00','purchase_price' => '400.00','purchase_price_inc_tax' => '400.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '5.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-04-10 11:43:12','updated_at' => '2018-06-13 11:39:09'),
  array('id' => '19','transaction_id' => '27','product_id' => '42','variation_id' => '85','quantity' => '50','pp_without_discount' => '520.00','discount_percent' => '0.00','purchase_price' => '520.00','purchase_price_inc_tax' => '520.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '20.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-04-10 11:53:36','updated_at' => '2018-06-13 11:39:09'),
  array('id' => '20','transaction_id' => '37','product_id' => '61','variation_id' => '104','quantity' => '20','pp_without_discount' => '34.00','discount_percent' => '0.00','purchase_price' => '34.00','purchase_price_inc_tax' => '34.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-11 16:47:07','updated_at' => '2018-06-13 11:39:07'),
  array('id' => '21','transaction_id' => '37','product_id' => '64','variation_id' => '107','quantity' => '200','pp_without_discount' => '10.00','discount_percent' => '0.00','purchase_price' => '10.00','purchase_price_inc_tax' => '10.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-11 16:47:07','updated_at' => '2018-06-13 11:39:07'),
  array('id' => '22','transaction_id' => '37','product_id' => '63','variation_id' => '106','quantity' => '200','pp_without_discount' => '10.00','discount_percent' => '0.00','purchase_price' => '10.00','purchase_price_inc_tax' => '10.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-11 16:47:07','updated_at' => '2018-06-13 11:39:07'),
  array('id' => '23','transaction_id' => '37','product_id' => '65','variation_id' => '108','quantity' => '50','pp_without_discount' => '10.00','discount_percent' => '0.00','purchase_price' => '10.00','purchase_price_inc_tax' => '10.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-11 16:47:07','updated_at' => '2018-06-13 11:39:07'),
  array('id' => '24','transaction_id' => '38','product_id' => '17','variation_id' => '57','quantity' => '30','pp_without_discount' => '350.00','discount_percent' => '0.00','purchase_price' => '350.00','purchase_price_inc_tax' => '350.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '25','transaction_id' => '38','product_id' => '17','variation_id' => '58','quantity' => '50','pp_without_discount' => '350.00','discount_percent' => '0.00','purchase_price' => '350.00','purchase_price_inc_tax' => '350.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '26','transaction_id' => '38','product_id' => '64','variation_id' => '107','quantity' => '100','pp_without_discount' => '10.00','discount_percent' => '0.00','purchase_price' => '10.00','purchase_price_inc_tax' => '10.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '27','transaction_id' => '38','product_id' => '15','variation_id' => '49','quantity' => '30','pp_without_discount' => '950.00','discount_percent' => '0.00','purchase_price' => '950.00','purchase_price_inc_tax' => '1045.00','item_tax' => '95.00','tax_id' => '1','quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '28','transaction_id' => '38','product_id' => '15','variation_id' => '50','quantity' => '20','pp_without_discount' => '950.00','discount_percent' => '0.00','purchase_price' => '950.00','purchase_price_inc_tax' => '1045.00','item_tax' => '95.00','tax_id' => '1','quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '29','transaction_id' => '38','product_id' => '15','variation_id' => '51','quantity' => '30','pp_without_discount' => '950.00','discount_percent' => '0.00','purchase_price' => '950.00','purchase_price_inc_tax' => '1045.00','item_tax' => '95.00','tax_id' => '1','quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '30','transaction_id' => '38','product_id' => '15','variation_id' => '52','quantity' => '20','pp_without_discount' => '950.00','discount_percent' => '0.00','purchase_price' => '950.00','purchase_price_inc_tax' => '1045.00','item_tax' => '95.00','tax_id' => '1','quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '31','transaction_id' => '38','product_id' => '15','variation_id' => '53','quantity' => '40','pp_without_discount' => '1010.00','discount_percent' => '0.00','purchase_price' => '1010.00','purchase_price_inc_tax' => '1111.00','item_tax' => '101.00','tax_id' => '1','quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '32','transaction_id' => '38','product_id' => '18','variation_id' => '59','quantity' => '20','pp_without_discount' => '1350.00','discount_percent' => '0.00','purchase_price' => '1350.00','purchase_price_inc_tax' => '1350.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '33','transaction_id' => '38','product_id' => '18','variation_id' => '60','quantity' => '20','pp_without_discount' => '1450.00','discount_percent' => '0.00','purchase_price' => '1450.00','purchase_price_inc_tax' => '1450.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '34','transaction_id' => '38','product_id' => '63','variation_id' => '106','quantity' => '100','pp_without_discount' => '10.00','discount_percent' => '0.00','purchase_price' => '10.00','purchase_price_inc_tax' => '10.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '35','transaction_id' => '38','product_id' => '19','variation_id' => '61','quantity' => '30','pp_without_discount' => '8.00','discount_percent' => '0.00','purchase_price' => '8.00','purchase_price_inc_tax' => '8.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '36','transaction_id' => '38','product_id' => '22','variation_id' => '65','quantity' => '10','pp_without_discount' => '8.00','discount_percent' => '0.00','purchase_price' => '8.00','purchase_price_inc_tax' => '8.80','item_tax' => '0.80','tax_id' => '1','quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '37','transaction_id' => '38','product_id' => '24','variation_id' => '67','quantity' => '10','pp_without_discount' => '8.00','discount_percent' => '0.00','purchase_price' => '8.00','purchase_price_inc_tax' => '8.80','item_tax' => '0.80','tax_id' => '1','quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '38','transaction_id' => '38','product_id' => '25','variation_id' => '68','quantity' => '20','pp_without_discount' => '15.00','discount_percent' => '0.00','purchase_price' => '15.00','purchase_price_inc_tax' => '15.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '39','transaction_id' => '39','product_id' => '77','variation_id' => '120','quantity' => '100','pp_without_discount' => '3.00','discount_percent' => '0.00','purchase_price' => '3.00','purchase_price_inc_tax' => '3.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-07-13 07:34:45','updated_at' => '2018-07-13 07:34:45'),
  array('id' => '40','transaction_id' => '39','product_id' => '76','variation_id' => '119','quantity' => '200','pp_without_discount' => '8.00','discount_percent' => '0.00','purchase_price' => '8.00','purchase_price_inc_tax' => '8.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-07-13 07:34:45','updated_at' => '2018-07-13 07:34:45'),
  array('id' => '41','transaction_id' => '40','product_id' => '76','variation_id' => '119','quantity' => '100','pp_without_discount' => '8.00','discount_percent' => '0.00','purchase_price' => '8.00','purchase_price_inc_tax' => '8.00','item_tax' => '0.00','tax_id' => NULL,'quantity_sold' => '0.00','quantity_adjusted' => '0.00','mfg_date' => NULL,'exp_date' => NULL,'lot_number' => NULL,'created_at' => '2018-07-13 07:38:24','updated_at' => '2018-07-13 07:38:24')
  );
  DB::table('purchase_lines')->insert($purchase_lines);

        DB::insert("INSERT INTO transactions (id, business_id, location_id, type, status, payment_status, adjustment_type, contact_id, customer_group_id, invoice_no, ref_no, transaction_date, total_before_tax, tax_id, tax_amount, discount_type, discount_amount, shipping_details, shipping_charges, additional_notes, staff_note, final_total, expense_category_id, expense_for, commission_agent, document, is_direct_sale, exchange_rate, total_amount_recovered, transfer_parent_id, opening_stock_product_id, created_by, created_at, updated_at) VALUES
(1, 1, 1, 'purchase', 'received', 'paid', NULL, 2, NULL, NULL, '35001BCVX', '$last_15th_day', '50600.00', 1, '5060.00', NULL, '0', NULL, '0.00', NULL, NULL, '55660.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 1, '2018-01-06 06:57:11', '2018-01-06 06:57:11'),
(2, 1, 1, 'purchase', 'received', 'paid', NULL, 5, NULL, NULL, '35001BJGN', '$last_15th_day', '77000.00', 1, '7700.00', NULL, '0', NULL, '0.00', NULL, NULL, '84700.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 1, '2018-01-06 06:58:10', '2018-01-06 06:58:10'),
(3, 1, 1, 'purchase', 'received', 'partial', NULL, 6, NULL, NULL, '35001BCVJ', '$last_month', '5500.00', 1, '550.00', NULL, '0', NULL, '0.00', NULL, NULL, '6050.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 1, '2018-01-06 07:02:22', '2018-01-06 07:02:22'),
(4, 1, 1, 'purchase', 'received', 'paid', NULL, 6, NULL, NULL, '35001BCVK', '$last_month', '2000.00', NULL, '0.00', NULL, '0', NULL, '0.00', NULL, NULL, '2000.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 1, '2018-01-06 07:03:12', '2018-01-06 07:03:12'),
(5, 1, 1, 'purchase', 'received', 'due', NULL, 6, NULL, NULL, '35001BCVD', '$last_week', '11000.00', 1, '1100.00', NULL, '0', NULL, '0.00', NULL, NULL, '12100.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 1, '2018-01-06 07:05:26', '2018-01-06 07:05:26'),
(6, 1, 1, 'sell', 'final', 'paid', NULL, 4, NULL, 'AS0001', '', '2018-04-10 13:23:21', '770.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '770.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 1, '2018-01-06 07:06:11', '2018-01-06 07:06:11'),
(7, 1, 1, 'sell', 'final', 'paid', NULL, 1, NULL, 'AS0002', '', '$yesterday', '825.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '825.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 1, '2018-01-06 07:06:31', '2018-01-06 07:06:31'),
(8, 1, 1, 'sell', 'final', 'paid', NULL, 4, NULL, 'AS0003', '', '$yesterday', '7700.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '7700.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 1, '2018-01-06 07:07:22', '2018-01-06 07:07:22'),
(9, 1, 1, 'sell', 'final', 'paid', NULL, 1, NULL, 'AS0004', '', '$today', '750.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '750.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 1, '2018-01-06 07:07:45', '2018-01-06 07:07:45'),
(10, 1, 1, 'sell', 'final', 'paid', NULL, 1, NULL, 'AS0005', '', '$today', '412.50', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '412.50', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 1, '2018-01-06 07:08:03', '2018-01-06 07:08:03'),
(11, 2, 2, 'purchase', 'received', 'paid', NULL, 8, NULL, NULL, '56247065', '$last_week', '300.00', NULL, '0.00', NULL, '0', NULL, '0.00', NULL, NULL, '300.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 4, '2018-04-10 10:18:16', '2018-04-10 10:18:47'),
(12, 2, 2, 'purchase', 'received', 'paid', NULL, 9, NULL, NULL, '547887025', '$last_week', '1200.00', NULL, '0.00', NULL, '0', NULL, '0.00', NULL, NULL, '1200.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 4, '2018-04-10 10:19:40', '2018-04-10 10:19:49'),
(13, 2, 2, 'purchase', 'received', 'paid', NULL, 9, NULL, NULL, '45470025', '$last_month', '1350.00', NULL, '0.00', NULL, '0', NULL, '0.00', NULL, NULL, '1350.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 4, '2018-04-10 10:20:41', '2018-04-10 10:20:55'),
(14, 2, 2, 'purchase', 'received', 'partial', NULL, 9, NULL, NULL, '65589898', '$last_month', '2160.00', NULL, '0.00', NULL, '0', NULL, '0.00', NULL, NULL, '2160.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 4, '2018-04-10 10:21:38', '2018-04-10 10:22:10'),
(15, 2, 2, 'sell', 'final', 'paid', NULL, 7, NULL, '0001', '', '$yesterday', '75.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '75.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 4, '2018-04-10 10:23:35', '2018-04-10 10:23:35'),
(16, 2, 2, 'sell', 'final', 'paid', NULL, 7, NULL, '0002', '', '$yesterday', '105.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '105.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 4, '2018-04-10 10:23:58', '2018-04-10 10:23:58'),
(17, 2, 2, 'sell', 'final', 'paid', NULL, 7, NULL, '0003', '', '$today', '405.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '405.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 4, '2018-04-10 10:24:21', '2018-04-10 10:26:26'),
(18, 3, 3, 'purchase', 'received', 'paid', NULL, 11, NULL, NULL, '548471117', '$last_month', '9630.00', NULL, '0.00', NULL, '0', NULL, '0.00', NULL, NULL, '9630.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 5, '2018-04-10 11:39:54', '2018-04-10 11:40:02'),
(19, 3, 3, 'purchase', 'received', 'paid', NULL, 12, NULL, NULL, '548222220', '$last_week', '20000.00', NULL, '0.00', NULL, '0', NULL, '0.00', NULL, NULL, '20000.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 5, '2018-04-10 11:40:51', '2018-04-10 11:40:58'),
(20, 3, 3, 'purchase', 'received', 'paid', NULL, 12, NULL, NULL, '878445524', '$last_15th_day', '13500.00', NULL, '0.00', NULL, '0', NULL, '0.00', NULL, NULL, '13500.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 5, '2018-04-10 11:41:45', '2018-04-10 11:43:19'),
(21, 3, 3, 'purchase', 'received', 'paid', NULL, 12, NULL, NULL, '582500058', '$last_15th_day', '19500.00', NULL, '0.00', NULL, '0', NULL, '0.00', NULL, NULL, '19500.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 5, '2018-04-10 11:42:34', '2018-04-10 11:43:24'),
(22, 3, 3, 'purchase', 'received', 'partial', NULL, 11, NULL, NULL, '848485552', '$last_week', '12000.00', NULL, '0.00', NULL, '0', NULL, '0.00', NULL, NULL, '12000.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 5, '2018-04-10 11:43:12', '2018-04-10 11:43:35'),
(23, 3, 3, 'sell', 'final', 'paid', NULL, 10, NULL, 'AE0001', '', '$today', '2500.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '2500.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 5, '2018-04-10 11:44:47', '2018-04-10 11:47:10'),
(24, 3, 3, 'sell', 'final', 'paid', NULL, 10, NULL, 'AE0002', '', '$yesterday', '4875.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '4875.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 5, '2018-04-10 11:45:06', '2018-04-10 11:46:43'),
(25, 3, 3, 'sell', 'final', 'paid', NULL, 10, NULL, 'AE0003', '', '$yesterday', '625.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '625.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 5, '2018-04-10 11:46:02', '2018-04-10 11:46:02'),
(26, 3, 3, 'sell', 'final', 'paid', NULL, 10, NULL, 'AE0004', '', '$today', '15625.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '15625.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 5, '2018-04-10 11:48:48', '2018-04-10 11:48:48'),
(27, 3, 3, 'purchase', 'received', 'due', NULL, 12, NULL, NULL, '1545477882', '$last_15th_day', '26000.00', NULL, '0.00', NULL, '0', NULL, '0.00', NULL, NULL, '26000.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 5, '2018-04-10 11:53:36', '2018-04-10 11:53:36'),
(28, 3, 3, 'sell', 'final', 'paid', NULL, 10, NULL, 'AE0005', '', '$yesterday', '13000.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '13000.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 5, '2018-04-10 11:54:16', '2018-04-10 11:54:16'),
(29, 4, 4, 'sell', 'final', 'paid', NULL, 13, NULL, '0001', '', '$today', '656.25', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '656.25', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 6, '2018-04-10 13:04:40', '2018-04-10 13:04:40'),
(30, 4, 4, 'sell', 'final', 'paid', NULL, 13, NULL, '0002', '', '$yesterday', '250.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '250.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 6, '2018-04-10 13:04:54', '2018-04-10 13:04:54'),
(31, 4, 4, 'sell', 'final', 'paid', NULL, 13, NULL, '0003', '', '$today', '75.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '75.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 6, '2018-04-10 13:05:19', '2018-04-10 13:05:19'),
(32, 4, 4, 'sell', 'final', 'paid', NULL, 13, NULL, '0004', '', '$today', '37.50', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '37.50', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 6, '2018-04-10 13:07:50', '2018-04-10 13:07:50'),
(33, 4, 4, 'sell', 'final', 'paid', NULL, 13, NULL, '0005', '', '$yesterday', '375.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '375.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 6, '2018-04-10 13:08:01', '2018-04-10 13:08:01'),
(34, 4, 4, 'sell', 'final', 'paid', NULL, 13, NULL, '0006', '', '$yesterday', '250.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '250.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 6, '2018-04-10 13:08:15', '2018-04-10 13:08:15'),
(35, 4, 4, 'sell', 'final', 'paid', NULL, 13, NULL, '0007', '', '$today', '100.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '100.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 6, '2018-04-10 13:08:27', '2018-04-10 13:08:27'),
(36, 4, 4, 'sell', 'final', 'paid', NULL, 13, NULL, '0008', '', '$yesterday', '125.00', NULL, '0.00', 'percentage', '0', NULL, '0.00', NULL, NULL, '125.00', NULL, NULL, NULL, NULL, 0, '1.000', NULL, NULL, NULL, 6, '2018-04-10 13:08:49', '2018-04-10 13:08:49'),
(37, 1, 1, 'purchase', 'received', 'due', NULL, 6, NULL, NULL, 'PO2018/0001','$yesterday', '5180.00', NULL, '0.00', NULL, '0', NULL, '0.00', NULL, NULL, '5180.00', NULL, NULL, NULL, NULL, '0', '1.000', NULL, NULL, NULL, 1 , '2018-06-11 22:17:07', '2018-06-11 22:17:07'),
(38, 1, 1, 'purchase', 'received', 'due', NULL, 6, NULL, NULL, 'PO2018/0002', '$today', '235656.00', NULL,'0.00', NULL, '0', NULL, '0.00', NULL, NULL, '235656.00', NULL, NULL, NULL, NULL, '0', '1.000', NULL, NULL,NULL, 1, '2018-06-12 23:18:04', '2018-06-12 23:18:04')");

$new_transactions = array(
  array('id' => '39','business_id' => '5','location_id' => '5','res_table_id' => NULL,'res_waiter_id' => NULL,'res_order_status' => NULL,'type' => 'purchase','status' => 'received','is_quotation' => '0','payment_status' => 'due','adjustment_type' => NULL,'contact_id' => '15','customer_group_id' => NULL,'invoice_no' => NULL,'ref_no' => 'PO2018/0001','transaction_date' => '$yesterday','total_before_tax' => '1900.00','tax_id' => NULL,'tax_amount' => '0.00','discount_type' => NULL,'discount_amount' => '0','shipping_details' => NULL,'shipping_charges' => '0.00','additional_notes' => NULL,'staff_note' => NULL,'final_total' => '1900.00','expense_category_id' => NULL,'expense_for' => NULL,'commission_agent' => NULL,'document' => NULL,'is_direct_sale' => '0','exchange_rate' => '1.000','total_amount_recovered' => NULL,'transfer_parent_id' => NULL,'opening_stock_product_id' => NULL,'created_by' => '7','created_at' => '2018-07-13 07:34:45','updated_at' => '2018-07-13 07:34:45'),
  array('id' => '40','business_id' => '5','location_id' => '5','res_table_id' => NULL,'res_waiter_id' => NULL,'res_order_status' => NULL,'type' => 'purchase','status' => 'received','is_quotation' => '0','payment_status' => 'due','adjustment_type' => NULL,'contact_id' => '15','customer_group_id' => NULL,'invoice_no' => NULL,'ref_no' => 'PO2018/0002','transaction_date' => '$yesterday','total_before_tax' => '800.00','tax_id' => NULL,'tax_amount' => '0.00','discount_type' => NULL,'discount_amount' => '0','shipping_details' => NULL,'shipping_charges' => '0.00','additional_notes' => NULL,'staff_note' => NULL,'final_total' => '800.00','expense_category_id' => NULL,'expense_for' => NULL,'commission_agent' => NULL,'document' => NULL,'is_direct_sale' => '0','exchange_rate' => '1.000','total_amount_recovered' => NULL,'transfer_parent_id' => NULL,'opening_stock_product_id' => NULL,'created_by' => '7','created_at' => '2018-07-13 07:38:24','updated_at' => '2018-07-13 07:38:24'),
  array('id' => '41','business_id' => '5','location_id' => '5','res_table_id' => '1','res_waiter_id' => '8','res_order_status' => 'served','type' => 'sell','status' => 'final','is_quotation' => '0','payment_status' => 'paid','adjustment_type' => NULL,'contact_id' => '14','customer_group_id' => NULL,'invoice_no' => '0001','ref_no' => '','transaction_date' => $today,'total_before_tax' => '42.50','tax_id' => NULL,'tax_amount' => '0.00','discount_type' => 'percentage','discount_amount' => '0','shipping_details' => NULL,'shipping_charges' => '0.00','additional_notes' => NULL,'staff_note' => NULL,'final_total' => '42.50','expense_category_id' => NULL,'expense_for' => NULL,'commission_agent' => NULL,'document' => NULL,'is_direct_sale' => '0','exchange_rate' => '1.000','total_amount_recovered' => NULL,'transfer_parent_id' => NULL,'opening_stock_product_id' => NULL,'created_by' => '7','created_at' => '2018-07-13 07:44:40','updated_at' => '2018-07-13 07:48:07'),
  array('id' => '42','business_id' => '5','location_id' => '5','res_table_id' => '2','res_waiter_id' => '8','res_order_status' => NULL,'type' => 'sell','status' => 'final','is_quotation' => '0','payment_status' => 'paid','adjustment_type' => NULL,'contact_id' => '14','customer_group_id' => NULL,'invoice_no' => '0002','ref_no' => '','transaction_date' => $today,'total_before_tax' => '77.50','tax_id' => NULL,'tax_amount' => '0.00','discount_type' => 'percentage','discount_amount' => '0','shipping_details' => NULL,'shipping_charges' => '0.00','additional_notes' => NULL,'staff_note' => NULL,'final_total' => '77.50','expense_category_id' => NULL,'expense_for' => NULL,'commission_agent' => NULL,'document' => NULL,'is_direct_sale' => '0','exchange_rate' => '1.000','total_amount_recovered' => NULL,'transfer_parent_id' => NULL,'opening_stock_product_id' => NULL,'created_by' => '7','created_at' => '2018-07-13 07:45:28','updated_at' => '2018-07-13 07:45:29'),
  array('id' => '43','business_id' => '5','location_id' => '5','res_table_id' => '3','res_waiter_id' => '8','res_order_status' => NULL,'type' => 'sell','status' => 'final','is_quotation' => '0','payment_status' => 'paid','adjustment_type' => NULL,'contact_id' => '14','customer_group_id' => NULL,'invoice_no' => '0003','ref_no' => '','transaction_date' => $today,'total_before_tax' => '33.75','tax_id' => NULL,'tax_amount' => '0.00','discount_type' => 'percentage','discount_amount' => '0','shipping_details' => NULL,'shipping_charges' => '0.00','additional_notes' => NULL,'staff_note' => NULL,'final_total' => '33.75','expense_category_id' => NULL,'expense_for' => NULL,'commission_agent' => NULL,'document' => NULL,'is_direct_sale' => '0','exchange_rate' => '1.000','total_amount_recovered' => NULL,'transfer_parent_id' => NULL,'opening_stock_product_id' => NULL,'created_by' => '7','created_at' => '2018-07-13 07:46:04','updated_at' => '2018-07-13 07:46:04'),
  array('id' => '44','business_id' => '5','location_id' => '5','res_table_id' => NULL,'res_waiter_id' => NULL,'res_order_status' => 'cooked','type' => 'sell','status' => 'final','is_quotation' => '0','payment_status' => 'paid','adjustment_type' => NULL,'contact_id' => '14','customer_group_id' => NULL,'invoice_no' => '0004','ref_no' => '','transaction_date' => $today,'total_before_tax' => '71.25','tax_id' => NULL,'tax_amount' => '0.00','discount_type' => 'percentage','discount_amount' => '0','shipping_details' => NULL,'shipping_charges' => '0.00','additional_notes' => NULL,'staff_note' => NULL,'final_total' => '71.25','expense_category_id' => NULL,'expense_for' => NULL,'commission_agent' => NULL,'document' => NULL,'is_direct_sale' => '0','exchange_rate' => '1.000','total_amount_recovered' => NULL,'transfer_parent_id' => NULL,'opening_stock_product_id' => NULL,'created_by' => '7','created_at' => '2018-07-13 07:46:36','updated_at' => '2018-07-13 07:46:55')
);
DB::table('transactions')->insert($new_transactions);


        DB::insert("INSERT INTO transaction_payments (id, transaction_id, amount, method, card_transaction_number, card_number, card_type, card_holder_name, card_month, card_year, card_security, cheque_number, bank_account_number, paid_on, created_by, payment_for, parent_id, note, created_at, updated_at) VALUES
					(1, 6, '770.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-01-09 17:30:35', 1, NULL, NULL, NULL, '2018-01-06 01:36:11', '2018-01-06 01:36:11'),
(2, 7, '825.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-01-09 17:30:35', 1, NULL, NULL, NULL, '2018-01-06 01:36:31', '2018-01-06 01:36:31'),
(3, 8, '7700.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-01-09 17:30:35', 1, NULL, NULL, NULL, '2018-01-06 01:37:23', '2018-01-06 01:37:23'),
(4, 9, '750.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-01-09 17:30:35', 1, NULL, NULL, NULL, '2018-01-06 01:37:45', '2018-01-06 01:37:45'),
(5, 10, '412.50', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-01-09 17:30:35', 1, NULL, NULL, NULL, '2018-01-06 01:38:03', '2018-01-06 01:38:03'),
(6, 4, '2000.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-01-11 17:32:56', 1, NULL, NULL, 'Cash Payment', '2018-01-11 06:32:56', '2018-01-11 06:32:56'),
(7, 3, '3000.00', 'bank_transfer', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, '502110000631', '2018-01-11 17:34:10', 1, NULL, NULL, '3000 Paid Via Bank Transfer', '2018-01-11 06:34:10', '2018-01-11 06:34:10'),
(8, 2, '84700.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-01-11 17:34:36', 1, NULL, NULL, NULL, '2018-01-11 06:34:36', '2018-01-11 06:34:36'),
(9, 1, '50000.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-01-11 17:35:04', 1, NULL, NULL, NULL, '2018-01-11 06:35:04', '2018-01-11 06:35:04'),
(10, 1, '5660.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-01-11 17:35:17', 1, NULL, NULL, NULL, '2018-01-11 06:35:17', '2018-01-11 06:35:17'),
(11, 11, '300.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 15:48:47', 4, 8, NULL, NULL, '2018-04-10 10:18:47', '2018-04-10 10:18:47'),
(12, 12, '1200.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 15:49:49', 4, 9, NULL, NULL, '2018-04-10 10:19:49', '2018-04-10 10:19:49'),
(13, 13, '1350.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 15:50:55', 4, 9, NULL, NULL, '2018-04-10 10:20:55', '2018-04-10 10:20:55'),
(14, 14, '1500.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 15:52:10', 4, 9, NULL, NULL, '2018-04-10 10:22:10', '2018-04-10 10:22:10'),
(15, 15, '75.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 15:53:35', 4, 7, NULL, NULL, '2018-04-10 10:23:35', '2018-04-10 10:23:35'),
(16, 16, '105.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 15:53:58', 4, 7, NULL, NULL, '2018-04-10 10:23:58', '2018-04-10 10:23:58'),
(17, 17, '405.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 15:54:21', 4, 7, NULL, NULL, '2018-04-10 10:24:21', '2018-04-10 10:26:26'),
(18, 18, '9630.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 17:10:02', 5, 11, NULL, NULL, '2018-04-10 11:40:02', '2018-04-10 11:40:02'),
(19, 19, '20000.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 17:10:58', 5, 12, NULL, NULL, '2018-04-10 11:40:58', '2018-04-10 11:40:58'),
(20, 20, '13500.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 17:13:19', 5, 12, NULL, NULL, '2018-04-10 11:43:19', '2018-04-10 11:43:19'),
(21, 21, '19500.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 17:13:24', 5, 12, NULL, NULL, '2018-04-10 11:43:24', '2018-04-10 11:43:24'),
(22, 22, '5000.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 17:13:35', 5, 11, NULL, NULL, '2018-04-10 11:43:35', '2018-04-10 11:43:35'),
(23, 23, '2500.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 17:14:47', 5, 10, NULL, NULL, '2018-04-10 11:44:47', '2018-04-10 11:47:10'),
(24, 24, '4875.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 17:15:06', 5, 10, NULL, NULL, '2018-04-10 11:45:06', '2018-04-10 11:46:43'),
(25, 25, '625.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 17:16:02', 5, 10, NULL, NULL, '2018-04-10 11:46:02', '2018-04-10 11:46:02'),
(26, 26, '15625.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 17:18:48', 5, 10, NULL, NULL, '2018-04-10 11:48:48', '2018-04-10 11:48:48'),
(27, 28, '13000.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 17:24:16', 5, 10, NULL, NULL, '2018-04-10 11:54:16', '2018-04-10 11:54:16'),
(28, 29, '656.25', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 18:34:40', 6, 13, NULL, NULL, '2018-04-10 13:04:40', '2018-04-10 13:04:40'),
(29, 30, '250.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 18:34:54', 6, 13, NULL, NULL, '2018-04-10 13:04:54', '2018-04-10 13:04:54'),
(30, 31, '75.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 18:35:19', 6, 13, NULL, NULL, '2018-04-10 13:05:19', '2018-04-10 13:05:19'),
(31, 32, '37.50', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 18:37:50', 6, 13, NULL, NULL, '2018-04-10 13:07:50', '2018-04-10 13:07:50'),
(32, 33, '375.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 18:38:01', 6, 13, NULL, NULL, '2018-04-10 13:08:01', '2018-04-10 13:08:01'),
(33, 34, '250.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 18:38:15', 6, 13, NULL, NULL, '2018-04-10 13:08:15', '2018-04-10 13:08:15'),
(34, 35, '100.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 18:38:27', 6, 13, NULL, NULL, '2018-04-10 13:08:27', '2018-04-10 13:08:27'),
(35, 36, '125.00', 'cash', NULL, NULL, 'visa', NULL, NULL, NULL, NULL, NULL, NULL, '2018-04-10 18:38:49', 6, 13, NULL, NULL, '2018-04-10 13:08:49', '2018-04-10 13:08:49')");

$transaction_sell_lines = array(
  array('id' => '1','transaction_id' => '6','product_id' => '2','variation_id' => '3','quantity' => '10','unit_price' => '70.00','unit_price_inc_tax' => '77.00','item_tax' => '7.00','tax_id' => '1','sell_line_note' => NULL,'parent_sell_line_id' => NULL,'created_at' => '2018-01-06 07:06:11','updated_at' => '2018-01-06 07:06:11'),
  array('id' => '2','transaction_id' => '7','product_id' => '27','variation_id' => '70','quantity' => '30','unit_price' => '25.00','unit_price_inc_tax' => '27.50','item_tax' => '2.50','tax_id' => '1','sell_line_note' => NULL,'parent_sell_line_id' => NULL,'created_at' => '2018-01-06 07:06:31','updated_at' => '2018-01-06 07:06:31'),
  array('id' => '3','transaction_id' => '8','product_id' => '2','variation_id' => '3','quantity' => '50','unit_price' => '70.00','unit_price_inc_tax' => '77.00','item_tax' => '7.00','tax_id' => '1','sell_line_note' => NULL,'parent_sell_line_id' => NULL,'created_at' => '2018-01-06 07:07:23','updated_at' => '2018-01-06 07:07:23'),
  array('id' => '4','transaction_id' => '8','product_id' => '2','variation_id' => '2','quantity' => '50','unit_price' => '70.00','unit_price_inc_tax' => '77.00','item_tax' => '7.00','tax_id' => '1','sell_line_note' => NULL,'parent_sell_line_id' => NULL,'created_at' => '2018-01-06 07:07:23','updated_at' => '2018-01-06 07:07:23'),
  array('id' => '5','transaction_id' => '9','product_id' => '21','variation_id' => '64','quantity' => '60','unit_price' => '12.50','unit_price_inc_tax' => '12.50','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => NULL,'parent_sell_line_id' => NULL,'created_at' => '2018-01-06 07:07:45','updated_at' => '2018-01-06 07:07:45'),
  array('id' => '6','transaction_id' => '10','product_id' => '28','variation_id' => '71','quantity' => '30','unit_price' => '12.50','unit_price_inc_tax' => '13.75','item_tax' => '1.25','tax_id' => '1','sell_line_note' => NULL,'parent_sell_line_id' => NULL,'created_at' => '2018-01-06 07:08:03','updated_at' => '2018-01-06 07:08:03'),
  array('id' => '7','transaction_id' => '15','product_id' => '34','variation_id' => '77','quantity' => '10','unit_price' => '7.50','unit_price_inc_tax' => '7.50','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 10:23:35','updated_at' => '2018-04-10 10:23:35'),
  array('id' => '8','transaction_id' => '16','product_id' => '32','variation_id' => '75','quantity' => '7','unit_price' => '15.00','unit_price_inc_tax' => '15.00','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 10:23:58','updated_at' => '2018-04-10 10:23:58'),
  array('id' => '9','transaction_id' => '17','product_id' => '33','variation_id' => '76','quantity' => '27','unit_price' => '15.00','unit_price_inc_tax' => '15.00','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 10:24:21','updated_at' => '2018-04-10 10:26:26'),
  array('id' => '10','transaction_id' => '23','product_id' => '43','variation_id' => '86','quantity' => '5','unit_price' => '500.00','unit_price_inc_tax' => '500.00','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => 'IHN45822225007','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 11:44:47','updated_at' => '2018-04-10 11:47:10'),
  array('id' => '11','transaction_id' => '24','product_id' => '44','variation_id' => '87','quantity' => '20','unit_price' => '243.75','unit_price_inc_tax' => '243.75','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => 'SMJ7558455524','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 11:45:06','updated_at' => '2018-04-10 11:46:43'),
  array('id' => '12','transaction_id' => '25','product_id' => '41','variation_id' => '84','quantity' => '1','unit_price' => '625.00','unit_price_inc_tax' => '625.00','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => 'EXSD1225778855','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 11:46:02','updated_at' => '2018-04-10 11:46:02'),
  array('id' => '13','transaction_id' => '26','product_id' => '41','variation_id' => '84','quantity' => '25','unit_price' => '625.00','unit_price_inc_tax' => '625.00','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => 'HP020555548444','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 11:48:48','updated_at' => '2018-04-10 11:48:48'),
  array('id' => '14','transaction_id' => '28','product_id' => '42','variation_id' => '85','quantity' => '20','unit_price' => '650.00','unit_price_inc_tax' => '650.00','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => 'HP68400258F','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 11:54:16','updated_at' => '2018-04-10 11:54:16'),
  array('id' => '15','transaction_id' => '29','product_id' => '53','variation_id' => '96','quantity' => '5','unit_price' => '131.25','unit_price_inc_tax' => '131.25','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 13:04:40','updated_at' => '2018-04-10 13:04:40'),
  array('id' => '16','transaction_id' => '30','product_id' => '51','variation_id' => '94','quantity' => '2','unit_price' => '125.00','unit_price_inc_tax' => '125.00','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 13:04:54','updated_at' => '2018-04-10 13:04:54'),
  array('id' => '17','transaction_id' => '31','product_id' => '57','variation_id' => '100','quantity' => '3','unit_price' => '25.00','unit_price_inc_tax' => '25.00','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 13:05:19','updated_at' => '2018-04-10 13:05:19'),
  array('id' => '18','transaction_id' => '32','product_id' => '60','variation_id' => '103','quantity' => '2','unit_price' => '18.75','unit_price_inc_tax' => '18.75','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 13:07:50','updated_at' => '2018-04-10 13:07:50'),
  array('id' => '19','transaction_id' => '33','product_id' => '56','variation_id' => '99','quantity' => '2','unit_price' => '187.50','unit_price_inc_tax' => '187.50','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 13:08:01','updated_at' => '2018-04-10 13:08:01'),
  array('id' => '20','transaction_id' => '34','product_id' => '54','variation_id' => '97','quantity' => '20','unit_price' => '12.50','unit_price_inc_tax' => '12.50','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 13:08:15','updated_at' => '2018-04-10 13:08:15'),
  array('id' => '21','transaction_id' => '35','product_id' => '55','variation_id' => '98','quantity' => '10','unit_price' => '10.00','unit_price_inc_tax' => '10.00','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 13:08:27','updated_at' => '2018-04-10 13:08:27'),
  array('id' => '22','transaction_id' => '36','product_id' => '57','variation_id' => '100','quantity' => '5','unit_price' => '25.00','unit_price_inc_tax' => '25.00','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-04-10 13:08:49','updated_at' => '2018-04-10 13:08:49'),
  array('id' => '23','transaction_id' => '41','product_id' => '71','variation_id' => '114','quantity' => '2','unit_price' => '21.25','unit_price_inc_tax' => '21.25','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-07-13 07:44:40','updated_at' => '2018-07-13 07:44:40'),
  array('id' => '24','transaction_id' => '42','product_id' => '70','variation_id' => '113','quantity' => '2','unit_price' => '15.00','unit_price_inc_tax' => '15.00','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-07-13 07:45:28','updated_at' => '2018-07-13 07:45:28'),
  array('id' => '25','transaction_id' => '42','product_id' => '67','variation_id' => '110','quantity' => '2','unit_price' => '10.00','unit_price_inc_tax' => '10.00','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-07-13 07:45:28','updated_at' => '2018-07-13 07:45:28'),
  array('id' => '26','transaction_id' => '42','product_id' => '68','variation_id' => '111','quantity' => '2','unit_price' => '13.75','unit_price_inc_tax' => '13.75','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-07-13 07:45:28','updated_at' => '2018-07-13 07:45:28'),
  array('id' => '27','transaction_id' => '43','product_id' => '74','variation_id' => '117','quantity' => '1','unit_price' => '8.75','unit_price_inc_tax' => '8.75','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-07-13 07:46:04','updated_at' => '2018-07-13 07:46:04'),
  array('id' => '28','transaction_id' => '43','product_id' => '73','variation_id' => '116','quantity' => '1','unit_price' => '25.00','unit_price_inc_tax' => '25.00','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-07-13 07:46:04','updated_at' => '2018-07-13 07:46:04'),
  array('id' => '29','transaction_id' => '44','product_id' => '74','variation_id' => '117','quantity' => '3','unit_price' => '8.75','unit_price_inc_tax' => '8.75','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-07-13 07:46:36','updated_at' => '2018-07-13 07:46:36'),
  array('id' => '30','transaction_id' => '44','product_id' => '69','variation_id' => '112','quantity' => '3','unit_price' => '15.00','unit_price_inc_tax' => '15.00','item_tax' => '0.00','tax_id' => NULL,'sell_line_note' => '','parent_sell_line_id' => NULL,'created_at' => '2018-07-13 07:46:36','updated_at' => '2018-07-13 07:46:36')
);

DB::table('transaction_sell_lines')->insert($transaction_sell_lines);

$variation_location_details = array(
  array('id' => '1','product_id' => '2','product_variation_id' => '2','variation_id' => '2','location_id' => '1','qty_available' => '50.00','created_at' => '2018-01-06 06:57:11','updated_at' => '2018-01-06 07:07:23'),
  array('id' => '2','product_id' => '2','product_variation_id' => '2','variation_id' => '3','location_id' => '1','qty_available' => '90.00','created_at' => '2018-01-06 06:57:11','updated_at' => '2018-01-06 07:07:23'),
  array('id' => '3','product_id' => '2','product_variation_id' => '2','variation_id' => '4','location_id' => '1','qty_available' => '150.00','created_at' => '2018-01-06 06:57:11','updated_at' => '2018-01-06 06:57:11'),
  array('id' => '4','product_id' => '2','product_variation_id' => '2','variation_id' => '5','location_id' => '1','qty_available' => '150.00','created_at' => '2018-01-06 06:57:11','updated_at' => '2018-01-06 06:57:11'),
  array('id' => '5','product_id' => '2','product_variation_id' => '2','variation_id' => '6','location_id' => '1','qty_available' => '100.00','created_at' => '2018-01-06 06:57:11','updated_at' => '2018-01-06 06:57:11'),
  array('id' => '6','product_id' => '14','product_variation_id' => '15','variation_id' => '47','location_id' => '1','qty_available' => '100.00','created_at' => '2018-01-06 06:58:10','updated_at' => '2018-01-06 06:58:10'),
  array('id' => '7','product_id' => '28','product_variation_id' => '30','variation_id' => '71','location_id' => '1','qty_available' => '470.00','created_at' => '2018-01-06 07:02:22','updated_at' => '2018-01-06 07:08:03'),
  array('id' => '8','product_id' => '21','product_variation_id' => '23','variation_id' => '64','location_id' => '1','qty_available' => '140.00','created_at' => '2018-01-06 07:03:12','updated_at' => '2018-01-06 07:07:45'),
  array('id' => '9','product_id' => '27','product_variation_id' => '29','variation_id' => '70','location_id' => '1','qty_available' => '470.00','created_at' => '2018-01-06 07:05:26','updated_at' => '2018-01-06 07:06:32'),
  array('id' => '10','product_id' => '34','product_variation_id' => '36','variation_id' => '77','location_id' => '2','qty_available' => '40.00','created_at' => '2018-04-10 10:18:16','updated_at' => '2018-04-10 10:23:35'),
  array('id' => '11','product_id' => '32','product_variation_id' => '34','variation_id' => '75','location_id' => '2','qty_available' => '93.00','created_at' => '2018-04-10 10:19:40','updated_at' => '2018-04-10 10:23:58'),
  array('id' => '12','product_id' => '36','product_variation_id' => '38','variation_id' => '79','location_id' => '2','qty_available' => '150.00','created_at' => '2018-04-10 10:20:41','updated_at' => '2018-04-10 10:20:41'),
  array('id' => '13','product_id' => '33','product_variation_id' => '35','variation_id' => '76','location_id' => '2','qty_available' => '153.00','created_at' => '2018-04-10 10:21:38','updated_at' => '2018-04-10 10:24:21'),
  array('id' => '14','product_id' => '46','product_variation_id' => '48','variation_id' => '89','location_id' => '3','qty_available' => '30.00','created_at' => '2018-04-10 11:39:54','updated_at' => '2018-04-10 11:39:54'),
  array('id' => '15','product_id' => '41','product_variation_id' => '43','variation_id' => '84','location_id' => '3','qty_available' => '14.00','created_at' => '2018-04-10 11:40:51','updated_at' => '2018-04-10 11:48:48'),
  array('id' => '16','product_id' => '45','product_variation_id' => '47','variation_id' => '88','location_id' => '3','qty_available' => '45.00','created_at' => '2018-04-10 11:41:45','updated_at' => '2018-04-10 11:41:45'),
  array('id' => '17','product_id' => '44','product_variation_id' => '46','variation_id' => '87','location_id' => '3','qty_available' => '80.00','created_at' => '2018-04-10 11:42:34','updated_at' => '2018-04-10 11:45:06'),
  array('id' => '18','product_id' => '43','product_variation_id' => '45','variation_id' => '86','location_id' => '3','qty_available' => '25.00','created_at' => '2018-04-10 11:43:12','updated_at' => '2018-04-10 11:44:47'),
  array('id' => '19','product_id' => '42','product_variation_id' => '44','variation_id' => '85','location_id' => '3','qty_available' => '30.00','created_at' => '2018-04-10 11:53:36','updated_at' => '2018-04-10 11:54:16'),
  array('id' => '20','product_id' => '61','product_variation_id' => '63','variation_id' => '104','location_id' => '1','qty_available' => '20.00','created_at' => '2018-06-11 22:17:07','updated_at' => '2018-06-11 22:17:07'),
  array('id' => '21','product_id' => '64','product_variation_id' => '66','variation_id' => '107','location_id' => '1','qty_available' => '300.00','created_at' => '2018-06-11 22:17:07','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '22','product_id' => '63','product_variation_id' => '65','variation_id' => '106','location_id' => '1','qty_available' => '300.00','created_at' => '2018-06-11 22:17:07','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '23','product_id' => '65','product_variation_id' => '67','variation_id' => '108','location_id' => '1','qty_available' => '50.00','created_at' => '2018-06-11 22:17:07','updated_at' => '2018-06-11 22:17:07'),
  array('id' => '24','product_id' => '17','product_variation_id' => '19','variation_id' => '57','location_id' => '1','qty_available' => '30.00','created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '25','product_id' => '17','product_variation_id' => '19','variation_id' => '58','location_id' => '1','qty_available' => '50.00','created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '26','product_id' => '15','product_variation_id' => '16','variation_id' => '49','location_id' => '1','qty_available' => '30.00','created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '27','product_id' => '15','product_variation_id' => '16','variation_id' => '50','location_id' => '1','qty_available' => '20.00','created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '28','product_id' => '15','product_variation_id' => '16','variation_id' => '51','location_id' => '1','qty_available' => '30.00','created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '29','product_id' => '15','product_variation_id' => '17','variation_id' => '52','location_id' => '1','qty_available' => '20.00','created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '30','product_id' => '15','product_variation_id' => '17','variation_id' => '53','location_id' => '1','qty_available' => '40.00','created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '31','product_id' => '18','product_variation_id' => '20','variation_id' => '59','location_id' => '1','qty_available' => '20.00','created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '32','product_id' => '18','product_variation_id' => '20','variation_id' => '60','location_id' => '1','qty_available' => '20.00','created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '33','product_id' => '19','product_variation_id' => '21','variation_id' => '61','location_id' => '1','qty_available' => '30.00','created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '34','product_id' => '22','product_variation_id' => '24','variation_id' => '65','location_id' => '1','qty_available' => '10.00','created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '35','product_id' => '24','product_variation_id' => '26','variation_id' => '67','location_id' => '1','qty_available' => '10.00','created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '36','product_id' => '25','product_variation_id' => '27','variation_id' => '68','location_id' => '1','qty_available' => '20.00','created_at' => '2018-06-12 23:18:04','updated_at' => '2018-06-12 23:18:04'),
  array('id' => '37','product_id' => '77','product_variation_id' => '79','variation_id' => '120','location_id' => '5','qty_available' => '100.00','created_at' => '2018-07-13 07:34:45','updated_at' => '2018-07-13 07:34:45'),
  array('id' => '38','product_id' => '76','product_variation_id' => '78','variation_id' => '119','location_id' => '5','qty_available' => '300.00','created_at' => '2018-07-13 07:34:45','updated_at' => '2018-07-13 07:38:24')
);
DB::table('variation_location_details')->insert($variation_location_details);

        //Roles and permissions for business 1
        $admin_role1 = Role::create( [ 'name' => 'Admin#1', 
                                'business_id' => 1, 
                                'guard_name' => 'web', 
                                'is_default' => 1
                            ]);
        $cashier_role1 = Role::create( [ 'name' => 'Cashier#1', 
                                'business_id' => 1, 
                                'guard_name' => 'web'
                            ]);
        

        $cashier_role1->syncPermissions(['sell.view', 'sell.create', 'sell.update', 'sell.delete', 
        	'access_all_locations']);

        $admin1 = User::findOrFail(1);
        $cashier1 = User::findOrFail(2);
        $demo_user1 = User::findOrFail(3);

        $admin1->assignRole('Admin#1');
        $cashier1->assignRole('Cashier#1');
        $demo_user1->assignRole('Admin#1');
        Permission::insert(['name' => 'location.1', 'guard_name' => 'web', 'created_at' => \Carbon::now()->toDateTimeString()]);

        //Roles and permissions for business 2
        $admin_role2 = Role::create( [ 'name' => 'Admin#2', 
                                'business_id' => 2, 
                                'guard_name' => 'web', 
                                'is_default' => 1
                            ]);
        $cashier_role2 = Role::create( [ 'name' => 'Cashier#2', 
                                'business_id' => 2, 
                                'guard_name' => 'web'
                            ]);
        

        $cashier_role2->syncPermissions(['sell.view', 'sell.create', 'sell.update', 'sell.delete', 
        	'access_all_locations']);

        $admin2 = User::findOrFail(4);

        $admin2->assignRole('Admin#2');
        Permission::insert(['name' => 'location.2', 'guard_name' => 'web', 'created_at' => \Carbon::now()->toDateTimeString()]);

        //Roles and permissions for business 3
        $admin_role3 = Role::create( [ 'name' => 'Admin#3', 
                                'business_id' => 3, 
                                'guard_name' => 'web'
                            ]);
        $cashier_role3 = Role::create( [ 'name' => 'Cashier#3', 
                                'business_id' => 3, 
                                'guard_name' => 'web'
                            ]);
        

        $cashier_role3->syncPermissions(['sell.view', 'sell.create', 'sell.update', 'sell.delete', 
        	'access_all_locations']);

        $admin3 = User::findOrFail(5);

        $admin3->assignRole('Admin#3');
        Permission::insert(['name' => 'location.3', 'guard_name' => 'web', 'created_at' => \Carbon::now()->toDateTimeString()]);

        //Roles and permissions for business 4
        $admin_role4 = Role::create( [ 'name' => 'Admin#4', 
                                'business_id' => 4, 
                                'guard_name' => 'web', 
                                'is_default' => 1
                            ]);
        $cashier_role4 = Role::create( [ 'name' => 'Cashier#4', 
                                'business_id' => 4, 
                                'guard_name' => 'web'
                            ]);
        

        $cashier_role4->syncPermissions(['sell.view', 'sell.create', 'sell.update', 'sell.delete', 
        	'access_all_locations']);

        $admin4 = User::findOrFail(6);

        $admin4->assignRole('Admin#4');
        Permission::insert(['name' => 'location.4', 'guard_name' => 'web', 'created_at' => \Carbon::now()->toDateTimeString()]);

        //Roles and permissions for business 5
        $admin_role5 = Role::create( [ 'name' => 'Admin#5', 
                                'business_id' => 5, 
                                'guard_name' => 'web', 
                                'is_default' => 1
                            ]);
        $cashier_role5 = Role::create( [ 'name' => 'Cashier#5', 
                                'business_id' => 5, 
                                'guard_name' => 'web'
                            ]);
        

        $cashier_role5->syncPermissions(['sell.view', 'sell.create', 'sell.update', 'sell.delete', 
          'access_all_locations']);

        $admin5 = User::findOrFail(7);

        $admin5->assignRole('Admin#5');
        Permission::insert(['name' => 'location.5', 'guard_name' => 'web', 'created_at' => \Carbon::now()->toDateTimeString()]);

        $waiter_role5 = Role::create( [ 'name' => 'Waiter#5', 
                                'business_id' => 5, 
                                'guard_name' => 'web',
                                'is_service_staff' => 1
                            ]);
        $waiter_role5->syncPermissions(['dashboard.data', 'access_all_locations']);
        $waiter5 = User::findOrFail(8);
        $waiter5->assignRole('Waiter#5');

        DB::statement("SET FOREIGN_KEY_CHECKS = 1");

        DB::commit();
    }
}
