<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;

use DB;

class Contact extends Model
{
    use Notifiable;

	use SoftDeletes;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    public function scopeOnlySuppliers($query)
    {
        return $query->whereIn( 'contacts.type', ['supplier', 'both'] );
    }

    public function scopeOnlyCustomers($query)
    {
        return $query->whereIn( 'type', ['customer', 'both'] );
    }

    /**
     * Return list of suppliers dropdown for a business
     *
     * @param $business_id int
     * @param $prepend_none = true (boolean)
     *
     * @return array users
     */
    public static function suppliersDropdown($business_id, $prepend_none = true)
    {

        $all_contacts = Contact::where('business_id', $business_id)
                        ->whereIn( 'type', ['supplier', 'both'] )
                        ->select('id', DB::raw("CONCAT(name, ' (', supplier_business_name, ')') as supplier"));

        $suppliers = $all_contacts->pluck('supplier', 'id');

        //Prepend none
        if($prepend_none){
            $suppliers = $suppliers->prepend(__('lang_v1.none'), '');
        }

        return $suppliers;
    }

    /**
     * Return list of customers dropdown for a business
     *
     * @param $business_id int
     * @param $prepend_none = true (boolean)
     *
     * @return array users
     */
    public static function customersDropdown($business_id, $prepend_none = true)
    {

        $all_contacts = Contact::where('business_id', $business_id)
                        ->whereIn( 'type', ['customer', 'both'] )
                        ->select('id', DB::raw("name as customer"));

        $customers = $all_contacts->pluck('customer', 'id');

        //Prepend none
        if($prepend_none){
            $customers = $customers->prepend(__('lang_v1.none'), '');
        }

        return $customers;
    }
}
